package com.suncode.autoupdate.plusworkflow.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.autoupdate.plusworkflow.util.Consumer;
import com.suncode.autoupdate.server.client.ApiToken;
import com.suncode.autoupdate.server.client.Environment;
import lombok.*;
import lombok.experimental.Wither;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Wither
@ToString(exclude = "apiToken")
public class Config
{
    public static final String DEFAULT_ADDR = "https://www.aktualizacje.plusworkflow.pl";
    private static final String OLD_DEFAULT_ADDR = "http://www.aktualizacje.plusworkflow.pl";;

    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private String systemProject;
    private String systemChannel;
    private URI serverUrl = URI.create( DEFAULT_ADDR );

    private ApiToken apiToken;
    private Environment environment;

    @SneakyThrows
    public void save( Consumer<InputStream> consumer )
    {
        consumer.accept( new ByteArrayInputStream( OBJECT_MAPPER.writeValueAsBytes( this ) ) );
    }

    @SneakyThrows
    public static Config read(InputStream inputStream )
    {
        try {
            Config config = OBJECT_MAPPER.readValue(inputStream, Config.class);
            if (config.getServerUrl() == null || config.getServerUrl().equals(OLD_DEFAULT_ADDR)) {
                config.setServerUrl(URI.create(DEFAULT_ADDR));
            }
            return config;
        }
        catch (JsonProcessingException e) {
            throw new CorruptedConfigException(e);
        }
    }

    public static class ConfigBuilder
    {
        private URI serverUrl = URI.create( DEFAULT_ADDR );
    }
}
