/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.archive.merge;

import com.google.common.hash.HashCode;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Checksum;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.archive.PatchAssembler;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class ArchiveMerger {
    @NonNull
    private final Collection<Archive> archives;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive merge(File output) {
        try {
            Merger merged = this.archives.stream().peek(archive -> this.open((Archive)archive)).sorted(Comparator.comparingInt(archive -> Integer.parseInt(archive.getMeta().getFromVersion()))).reduce(new Merger(), Merger::apply, this.noParallel());
            Archive archive2 = merged.assemble(output);
            return archive2;
        }
        finally {
            this.archives.forEach(archive -> this.close((Archive)archive));
        }
    }

    private void open(Archive archive) {
        archive.open();
    }

    private void close(Archive archive) {
        archive.close();
    }

    private BinaryOperator<Merger> noParallel() {
        return (merger, merger2) -> {
            throw new UnsupportedOperationException();
        };
    }

    @ConstructorProperties(value={"archives"})
    public ArchiveMerger(@NonNull Collection<Archive> archives) {
        if (archives == null) {
            throw new NullPointerException("archives is marked non-null but is null");
        }
        this.archives = archives;
    }

    private final class Delete
    implements Change {
        private final String path;

        @Override
        public void apply(PatchAssembler assembler) {
            assembler.delete(this.path);
        }

        @Override
        public <T> T merge(Function<Add, T> add, Function<Update, T> update, Function<Delete, T> delete) {
            return delete.apply(this);
        }

        @ConstructorProperties(value={"path"})
        public Delete(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete other = (Delete)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "ArchiveMerger.Delete(path=" + this.getPath() + ")";
        }
    }

    private final class Update
    implements Change {
        private final String path;
        private final HashCode hashCode;
        private final Archive patch;

        @Override
        public void apply(PatchAssembler assembler) {
            try (InputStream in = this.patch.get(this.path);){
                assembler.update(this.path, in);
            }
        }

        @Override
        public <T> T merge(Function<Add, T> add, Function<Update, T> update, Function<Delete, T> delete) {
            return update.apply(this);
        }

        @ConstructorProperties(value={"path", "hashCode", "patch"})
        public Update(String path, HashCode hashCode, Archive patch) {
            this.path = path;
            this.hashCode = hashCode;
            this.patch = patch;
        }

        public String getPath() {
            return this.path;
        }

        public HashCode getHashCode() {
            return this.hashCode;
        }

        public Archive getPatch() {
            return this.patch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            Update other = (Update)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            HashCode this$hashCode = this.getHashCode();
            HashCode other$hashCode = other.getHashCode();
            if (this$hashCode == null ? other$hashCode != null : !this$hashCode.equals(other$hashCode)) {
                return false;
            }
            Archive this$patch = this.getPatch();
            Archive other$patch = other.getPatch();
            return !(this$patch == null ? other$patch != null : !this$patch.equals(other$patch));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            HashCode $hashCode = this.getHashCode();
            result = result * 59 + ($hashCode == null ? 43 : $hashCode.hashCode());
            Archive $patch = this.getPatch();
            result = result * 59 + ($patch == null ? 43 : $patch.hashCode());
            return result;
        }

        public String toString() {
            return "ArchiveMerger.Update(path=" + this.getPath() + ", hashCode=" + this.getHashCode() + ", patch=" + this.getPatch() + ")";
        }
    }

    private final class Add
    implements Change {
        private final String path;
        private final HashCode hashCode;
        private final Archive patch;

        @Override
        public void apply(PatchAssembler assembler) {
            try (InputStream in = this.patch.get(this.path);){
                assembler.add(this.path, in);
            }
        }

        @Override
        public <T> T merge(Function<Add, T> add, Function<Update, T> update, Function<Delete, T> delete) {
            return add.apply(this);
        }

        @ConstructorProperties(value={"path", "hashCode", "patch"})
        public Add(String path, HashCode hashCode, Archive patch) {
            this.path = path;
            this.hashCode = hashCode;
            this.patch = patch;
        }

        public String getPath() {
            return this.path;
        }

        public HashCode getHashCode() {
            return this.hashCode;
        }

        public Archive getPatch() {
            return this.patch;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Add)) {
                return false;
            }
            Add other = (Add)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            HashCode this$hashCode = this.getHashCode();
            HashCode other$hashCode = other.getHashCode();
            if (this$hashCode == null ? other$hashCode != null : !this$hashCode.equals(other$hashCode)) {
                return false;
            }
            Archive this$patch = this.getPatch();
            Archive other$patch = other.getPatch();
            return !(this$patch == null ? other$patch != null : !this$patch.equals(other$patch));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            HashCode $hashCode = this.getHashCode();
            result = result * 59 + ($hashCode == null ? 43 : $hashCode.hashCode());
            Archive $patch = this.getPatch();
            result = result * 59 + ($patch == null ? 43 : $patch.hashCode());
            return result;
        }

        public String toString() {
            return "ArchiveMerger.Add(path=" + this.getPath() + ", hashCode=" + this.getHashCode() + ", patch=" + this.getPatch() + ")";
        }
    }

    private static interface Change {
        public void apply(PatchAssembler var1);

        public <T> T merge(Function<Add, T> var1, Function<Update, T> var2, Function<Delete, T> var3);

        default public void visit(Consumer<Add> add, Consumer<Update> update, Consumer<Delete> delete) {
            this.merge(Change.asFn(add), Change.asFn(update), Change.asFn(delete));
        }

        public static <R, T> Function<R, T> asFn(Consumer<R> consumer) {
            return r -> {
                consumer.accept(r);
                return null;
            };
        }
    }

    private class Merger {
        Checksum stateZeroChecksum;
        String from;
        String to;
        Map<String, Change> changes = new HashMap<String, Change>();

        private Merger() {
        }

        public Merger apply(Archive archive) {
            if (this.stateZeroChecksum == null) {
                this.stateZeroChecksum = archive.getChecksum();
                this.from = archive.getMeta().getFromVersion();
            } else if (!archive.getMeta().getFromVersion().equals(this.to)) {
                throw new IllegalArgumentException(String.format("Not connected patch %s -> %s -\\> %s -> %s", this.from, this.to, archive.getMeta().getFromVersion(), archive.getMeta().getToVersion()));
            }
            this.to = archive.getMeta().getToVersion();
            Index index = archive.getIndex();
            Checksum checksum = archive.getChecksum();
            index.getAdded().forEach(addedPath -> this.changes.compute((String)addedPath, (path, change) -> {
                if (change == null) {
                    if (this.stateZeroChecksum.get((String)path) != null) {
                        throw new IllegalArgumentException("There is already file in stateZeroChecksum:" + path);
                    }
                    return new Add((String)path, index.getAddedChecksum((String)path), archive);
                }
                return change.merge(add -> (Update)this.notAllowed(), update -> (Update)this.notAllowed(), delete -> {
                    HashCode stateZero = this.stateZeroChecksum.get((String)path);
                    HashCode now = index.getAddedChecksum((String)path);
                    if (now.equals((Object)stateZero)) {
                        return null;
                    }
                    return new Update((String)path, now, archive);
                });
            }));
            index.getUpdated().forEach(updatedPath -> this.changes.compute((String)updatedPath, (path, change) -> {
                if (change == null) {
                    if (this.stateZeroChecksum.get((String)path) == null) {
                        throw new IllegalArgumentException("There no file in stateZeroChecksum:" + path);
                    }
                    return new Update((String)path, index.getUpdatedChecksum((String)path), archive);
                }
                return change.merge(add -> {
                    if (!add.getHashCode().equals((Object)checksum.get((String)path))) {
                        throw new IllegalStateException("Add confict");
                    }
                    return new Add((String)path, index.getUpdatedChecksum((String)path), archive);
                }, update -> {
                    if (!update.getHashCode().equals((Object)checksum.get((String)path))) {
                        throw new IllegalStateException("Add confict");
                    }
                    HashCode stateZero = this.stateZeroChecksum.get((String)path);
                    HashCode now = index.getUpdatedChecksum((String)path);
                    if (now.equals((Object)stateZero)) {
                        return null;
                    }
                    return new Update((String)path, now, archive);
                }, delete -> (Change)this.notAllowed());
            }));
            index.getDeleted().forEach(deletedPaths -> this.changes.compute((String)deletedPaths, (path, change) -> {
                if (change == null) {
                    if (this.stateZeroChecksum.get((String)path) == null) {
                        throw new IllegalArgumentException("There is no file in stateZeroChecksum:" + path);
                    }
                    return new Delete((String)path);
                }
                return change.merge(add -> null, update -> {
                    if (!update.getHashCode().equals((Object)checksum.get((String)path))) {
                        throw new IllegalArgumentException("Add confict");
                    }
                    return new Delete((String)path);
                }, delete -> new Delete((String)path));
            }));
            return this;
        }

        private <T> T notAllowed() {
            throw new IllegalArgumentException("Add confict");
        }

        Archive assemble(File output) {
            try (PatchAssembler assembler = new PatchAssembler(new PatchMeta(UUID.randomUUID().toString(), this.from, this.to), output);){
                this.stateZeroChecksum.getPaths().forEach(path -> assembler.checksum((String)path, this.stateZeroChecksum.get((String)path)));
                this.changes.forEach((path, change) -> change.visit(add -> add.apply(assembler), update -> update.apply(assembler), delete -> delete.apply(assembler)));
            }
            return new Archive(output);
        }
    }
}

