/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.archive;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchivePart;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchiveUtils;
import com.suncode.autoupdate.patch.plusworkflow.archive.Checksum;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.archive.Meta;
import com.suncode.autoupdate.patch.plusworkflow.archive.PatchAssembler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Archive
implements AutoCloseable {
    private final File source;
    private final boolean tempSource;
    private final Meta meta = new Meta();
    private final Index index = new Index();
    private final Checksum checksum = new Checksum();
    private ZipFile zip;

    public Archive(File source) {
        this(source, false);
    }

    Archive(File source, boolean temporary) {
        this.source = source;
        this.tempSource = temporary;
    }

    public File getFile() {
        return this.source;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Index getIndex() {
        return this.index;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void open() throws IOException {
        if (this.zip == null) {
            this.zip = new ZipFile(this.source);
            this.readArchivePart(this.meta);
            this.readArchivePart(this.index);
            this.readArchivePart(this.checksum);
        }
    }

    public InputStream get(String path) throws IOException {
        ZipEntry entry = this.zip.getEntry("data/" + path);
        if (entry == null) {
            throw new IOException("Entry not found: " + path);
        }
        return this.zip.getInputStream(entry);
    }

    private void readArchivePart(ArchivePart part) throws IOException {
        ZipEntry entry = this.zip.getEntry(part.location());
        try (InputStream in = this.zip.getInputStream(entry);){
            part.readFrom(in);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this.tempSource) {
                this.source.delete();
            }
            this.zip = null;
        }
    }

    public static Archive assemble(PatchMeta patch, PatchAssembler.Assemble assemble) throws IOException {
        File storage = File.createTempFile("patch-", ".zip");
        try (PatchAssembler assembler = new PatchAssembler(patch, storage);){
            assemble.assemble(assembler);
        }
        catch (IOException | RuntimeException e) {
            storage.delete();
            throw e;
        }
        return new Archive(storage, true);
    }

    public static Archive assemble(PatchMeta patch, File storage, PatchAssembler.Assemble assemble) throws IOException {
        try (PatchAssembler assembler = new PatchAssembler(patch, storage);){
            assemble.assemble(assembler);
        }
        return new Archive(storage);
    }

    public static PatchMeta readMeta(InputStream stream) {
        Meta meta = new Meta();
        ArchiveUtils.readArchivePart(stream, meta);
        return meta.get();
    }
}

