package com.suncode.autoupdate.patch.plugin;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;
import lombok.experimental.UtilityClass;

import static lombok.AccessLevel.PRIVATE;

@UtilityClass
public class PluginPatchProperties {
    public static String REQUIREMENTS = "requirements";
    public static String CHANGELOG = "changelog";
    public static String DOCUMENTATION = "documentation";

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @FieldDefaults(level = PRIVATE)
    public static class PluginRequirement {
        String id;
        String version;
        boolean mandatory;
    }
}
