package com.suncode.autoupdate.patch.plusworkflow;

import java.util.List;

import com.google.common.collect.Lists;

import lombok.Data;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;

@Data
public class ValidationResult {
    List<String> extra = Lists.newArrayList();
    List<String> missing = Lists.newArrayList();
    List<String> checksum = Lists.newArrayList();
    List<String> checksumAdded = Lists.newArrayList();
    List<String> checksumUpdated = Lists.newArrayList();
    List<String> checksumDeleted = Lists.newArrayList();

    public boolean valid() {
        return checksumAdded.isEmpty() &&
                checksumUpdated.isEmpty() &&
                checksumDeleted.isEmpty() &&
                checksum.isEmpty() &&
                missing.isEmpty();
    }

    public String toFormattedString() {
        StringBuilder formatted = new StringBuilder()
                .append("Validation success=")
                .append(valid());
        printPaths("checksum-added", formatted, checksumAdded);
        printPaths("checksum-updated", formatted, checksumUpdated);
        printPaths("checksum-deleted", formatted, checksumDeleted);
        printPaths("checksum-other", formatted, checksum);
        printPaths("missing", formatted, missing);
        printPaths("extra", formatted, extra);

        return formatted.toString();
    }

    private void printPaths(String prefix, StringBuilder output, List<String> paths) {
        output.append("\n").append(prefix).append(":");
        for (String path : paths) {
            output.append("\n\t\t").append(path);
        }
    }
}
