/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.archive;

import com.google.common.hash.HashCode;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchivePart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Checksum
extends ArchivePart {
    private final Map<String, HashCode> md5 = new HashMap<String, HashCode>();

    public void add(String path, HashCode md5) {
        this.md5.put(path, md5);
    }

    public Set<String> getPaths() {
        return this.md5.keySet();
    }

    public HashCode get(String path) {
        return this.md5.get(path);
    }

    @Override
    public String location() {
        return "checksum";
    }

    @Override
    protected void writeToProperties(Properties properties) {
        ArrayList<String> paths = new ArrayList<String>(this.md5.keySet());
        Collections.sort(paths);
        for (String path : paths) {
            properties.setProperty(path, this.md5.get(path).toString());
        }
    }

    @Override
    protected void readFromProperties(Properties properties) {
        for (String property : properties.stringPropertyNames()) {
            this.md5.put(property, HashCode.fromString((String)properties.getProperty(property)));
        }
    }
}

