/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow;

import com.google.common.collect.Lists;
import java.util.List;

public class ValidationResult {
    List<String> extra = Lists.newArrayList();
    List<String> missing = Lists.newArrayList();
    List<String> checksum = Lists.newArrayList();
    List<String> checksumAdded = Lists.newArrayList();
    List<String> checksumUpdated = Lists.newArrayList();
    List<String> checksumDeleted = Lists.newArrayList();

    public boolean valid() {
        return this.checksumAdded.isEmpty() && this.checksumUpdated.isEmpty() && this.checksumDeleted.isEmpty() && this.checksum.isEmpty() && this.missing.isEmpty();
    }

    public String toFormattedString() {
        StringBuilder formatted = new StringBuilder().append("Validation success=").append(this.valid());
        this.printPaths("checksum-added", formatted, this.checksumAdded);
        this.printPaths("checksum-updated", formatted, this.checksumUpdated);
        this.printPaths("checksum-deleted", formatted, this.checksumDeleted);
        this.printPaths("checksum-other", formatted, this.checksum);
        this.printPaths("missing", formatted, this.missing);
        this.printPaths("extra", formatted, this.extra);
        return formatted.toString();
    }

    private void printPaths(String prefix, StringBuilder output, List<String> paths) {
        output.append("\n").append(prefix).append(":");
        for (String path : paths) {
            output.append("\n\t\t").append(path);
        }
    }

    public List<String> getExtra() {
        return this.extra;
    }

    public List<String> getMissing() {
        return this.missing;
    }

    public List<String> getChecksum() {
        return this.checksum;
    }

    public List<String> getChecksumAdded() {
        return this.checksumAdded;
    }

    public List<String> getChecksumUpdated() {
        return this.checksumUpdated;
    }

    public List<String> getChecksumDeleted() {
        return this.checksumDeleted;
    }

    public void setExtra(List<String> extra) {
        this.extra = extra;
    }

    public void setMissing(List<String> missing) {
        this.missing = missing;
    }

    public void setChecksum(List<String> checksum) {
        this.checksum = checksum;
    }

    public void setChecksumAdded(List<String> checksumAdded) {
        this.checksumAdded = checksumAdded;
    }

    public void setChecksumUpdated(List<String> checksumUpdated) {
        this.checksumUpdated = checksumUpdated;
    }

    public void setChecksumDeleted(List<String> checksumDeleted) {
        this.checksumDeleted = checksumDeleted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$extra = this.getExtra();
        List<String> other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
            return false;
        }
        List<String> this$missing = this.getMissing();
        List<String> other$missing = other.getMissing();
        if (this$missing == null ? other$missing != null : !((Object)this$missing).equals(other$missing)) {
            return false;
        }
        List<String> this$checksum = this.getChecksum();
        List<String> other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        List<String> this$checksumAdded = this.getChecksumAdded();
        List<String> other$checksumAdded = other.getChecksumAdded();
        if (this$checksumAdded == null ? other$checksumAdded != null : !((Object)this$checksumAdded).equals(other$checksumAdded)) {
            return false;
        }
        List<String> this$checksumUpdated = this.getChecksumUpdated();
        List<String> other$checksumUpdated = other.getChecksumUpdated();
        if (this$checksumUpdated == null ? other$checksumUpdated != null : !((Object)this$checksumUpdated).equals(other$checksumUpdated)) {
            return false;
        }
        List<String> this$checksumDeleted = this.getChecksumDeleted();
        List<String> other$checksumDeleted = other.getChecksumDeleted();
        return !(this$checksumDeleted == null ? other$checksumDeleted != null : !((Object)this$checksumDeleted).equals(other$checksumDeleted));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        List<String> $missing = this.getMissing();
        result = result * 59 + ($missing == null ? 43 : ((Object)$missing).hashCode());
        List<String> $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        List<String> $checksumAdded = this.getChecksumAdded();
        result = result * 59 + ($checksumAdded == null ? 43 : ((Object)$checksumAdded).hashCode());
        List<String> $checksumUpdated = this.getChecksumUpdated();
        result = result * 59 + ($checksumUpdated == null ? 43 : ((Object)$checksumUpdated).hashCode());
        List<String> $checksumDeleted = this.getChecksumDeleted();
        result = result * 59 + ($checksumDeleted == null ? 43 : ((Object)$checksumDeleted).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(extra=" + this.getExtra() + ", missing=" + this.getMissing() + ", checksum=" + this.getChecksum() + ", checksumAdded=" + this.getChecksumAdded() + ", checksumUpdated=" + this.getChecksumUpdated() + ", checksumDeleted=" + this.getChecksumDeleted() + ")";
    }
}

