package com.suncode.autoupdate.patch.plusworkflow.pluspatch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.apache.commons.io.IOUtils;

import com.google.common.hash.HashCode;

/**
 * PlusPatch3 specification.
 * 
 * @author Cezary Kozar 26 kwi 2016
 */
public class PlusPatch3Spec
{
    private static final String[] MANDATORY_ENTRIES = { "info.txt",
                                                       "md5/md5.jar",
                                                       "md5/md5sum_new.md5",
                                                       "md5/md5sum_old.md5" };

    private static final String[] OPTIONAL_ENTRIES = { "delete.sh", "delete.bat", "md5/" };

    public static boolean matches( File file )
    {
        try
        {
            ZipFile zip = new ZipFile( file );
            return containsMandatoryEntries( zip );
        }
        catch ( IOException e )
        {
            return false;
        }
    }

    public static boolean isPlusPatchEntry( ZipEntry entry )
    {
        return matchesEntryName( entry, MANDATORY_ENTRIES ) || matchesEntryName( entry, OPTIONAL_ENTRIES );
    }

    public static Map<String, HashCode> newMd5( ZipFile zip )
        throws IOException
    {
        return readMd5( zip, "md5/md5sum_new.md5" );
    }

    public static Map<String, HashCode> oldMd5( ZipFile zip )
        throws IOException
    {
        return readMd5( zip, "md5/md5sum_old.md5" );
    }

    private static boolean matchesEntryName( ZipEntry entry, String[] entries )
    {
        for ( String name : entries )
        {
            if ( entry.getName().equals( name ) )
            {
                return true;
            }
        }
        return false;
    }

    private static boolean containsMandatoryEntries( ZipFile zip )
    {
        for ( String entry : MANDATORY_ENTRIES )
        {
            if ( zip.getEntry( entry ) == null )
            {
                return false;
            }
        }
        return true;
    }

    private static Map<String, HashCode> readMd5( ZipFile zip, String entry )
        throws IOException
    {
        Map<String, HashCode> md5 = new HashMap<>();
        try (InputStream in = zip.getInputStream( zip.getEntry( entry ) ))
        {
            for ( String line : IOUtils.readLines( in, "UTF-8" ) )
            {
                String[] parts = line.split( ";" );
                if ( parts.length != 2 )
                {
                    throw new IllegalStateException( "Unexpected file [" + entry + "] format: " + line );
                }
                md5.put( parts[0], HashCode.fromString( parts[1] ) );
            }
        }
        return md5;
    }
}
