package com.suncode.autoupdate.patch.plusworkflow.archive;

import java.util.Properties;

import com.suncode.autoupdate.patch.PatchMeta;

import lombok.ToString;

/**
 * <b>meta</b> file. Contains information about patch.
 * 
 * @author Cezary Kozar 19 maj 2016
 */
@ToString
public class Meta
    extends ArchivePart
{
    private PatchMeta patch;

    public Meta()
    {
    }

    public Meta( PatchMeta patch )
    {
        this.patch = patch;
    }

    @Override
    public String location()
    {
        return "meta";
    }

    @Override
    protected void writeToProperties( Properties properties )
    {
        properties.setProperty( "patchId", this.patch.getPatchId() );
        properties.setProperty( "fromVersion", this.patch.getFromVersion() );
        properties.setProperty( "toVersion", this.patch.getToVersion() );
    }

    @Override
    protected void readFromProperties( Properties properties )
    {
        String id = properties.getProperty( "patchId" );
        String from = properties.getProperty( "fromVersion" );
        String to = properties.getProperty( "toVersion" );

        this.patch = new PatchMeta( id, from, to );
    }

    public PatchMeta get() {
        return patch;
    }

    public String getPatchId()
    {
        return patch.getPatchId();
    }

    public String getFromVersion()
    {
        return patch.getFromVersion();
    }

    public String getToVersion()
    {
        return patch.getToVersion();
    }
}
