package com.suncode.autoupdate.patch.plusworkflow.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.google.common.hash.HashCode;

/**
 * <b>checksum</b> file. Contains informations about known application files and its checksums as
 * MD5.
 * 
 * @author Cezary Kozar 19 maj 2016
 */
public class Checksum
    extends ArchivePart
{
    private final Map<String, HashCode> md5 = new HashMap<>();

    public void add( String path, HashCode md5 )
    {
        this.md5.put( path, md5 );
    }

    public Set<String> getPaths()
    {
        return md5.keySet();
    }

    public HashCode get( String path )
    {
        return md5.get( path );
    }

    @Override
    public String location()
    {
        return "checksum";
    }

    @Override
    protected void writeToProperties( Properties properties )
    {
        List<String> paths = new ArrayList<>( md5.keySet() );
        Collections.sort( paths );

        for ( String path : paths )
        {
            properties.setProperty( path, md5.get( path ).toString() );
        }
    }

    @Override
    protected void readFromProperties( Properties properties )
    {
        for ( String property : properties.stringPropertyNames() )
        {
            md5.put( property, HashCode.fromString( properties.getProperty( property ) ) );
        }
    }

}
