package com.suncode.autoupdate.patch.plusworkflow.archive;

import lombok.SneakyThrows;
import lombok.experimental.UtilityClass;

import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * Archive utility class
 */
@UtilityClass
public class ArchiveUtils {

    public static Index readIndex(InputStream patch) {
        Index index = new Index();
        readArchivePart(patch, index);
        return index;
    }

    @SneakyThrows
    static void readArchivePart(InputStream inputStream, ArchivePart part) {
        ZipInputStream stream = new ZipInputStream(inputStream);
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            if (entry.getName().equals(part.location())) {
                part.readFrom(stream);
                return;
            }
        }
    }
}
