/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.pluspatch;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.PatchAssembler;
import com.suncode.autoupdate.patch.plusworkflow.pluspatch.PlusPatch3Spec;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PlusPatch3Transformer {
    private final PatchMeta patch;
    private final File archive;

    public PlusPatch3Transformer(PatchMeta patch, File patchArchive) {
        this.patch = patch;
        this.archive = patchArchive;
    }

    public static boolean isPlusPatch3(File archive) {
        return PlusPatch3Spec.matches(archive);
    }

    public Archive transform() throws IOException {
        try (final ZipFile zip = new ZipFile(this.archive);){
            final Map<String, HashCode> checksumOld = PlusPatch3Spec.oldMd5(zip);
            Map<String, HashCode> checksumNew = PlusPatch3Spec.newMd5(zip);
            final MapDifference diff = Maps.difference(checksumNew, checksumOld);
            Archive archive = Archive.assemble(this.patch, new PatchAssembler.Assemble(){

                @Override
                public void assemble(PatchAssembler patch) throws IOException {
                    ZipEntry zipEntry;
                    String path;
                    for (Map.Entry entry : checksumOld.entrySet()) {
                        patch.checksum((String)entry.getKey(), (HashCode)entry.getValue());
                    }
                    for (Map.Entry entry : diff.entriesOnlyOnLeft().entrySet()) {
                        path = (String)entry.getKey();
                        zipEntry = zip.getEntry(path);
                        patch.add(path, zip.getInputStream(zipEntry), (HashCode)entry.getValue());
                    }
                    for (Map.Entry entry : diff.entriesDiffering().entrySet()) {
                        path = (String)entry.getKey();
                        zipEntry = zip.getEntry(path);
                        patch.update(path, zip.getInputStream(zipEntry), (HashCode)((MapDifference.ValueDifference)entry.getValue()).leftValue());
                    }
                    for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
                        patch.delete((String)entry.getKey());
                    }
                }
            });
            return archive;
        }
    }
}

