/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.archive;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchivePart;
import com.suncode.autoupdate.patch.plusworkflow.archive.Checksum;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.archive.Meta;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class PatchAssembler
implements Closeable {
    private final Meta meta;
    private final Index index = new Index();
    private final Checksum checksum = new Checksum();
    private final ZipOutputStream zip;

    public PatchAssembler(PatchMeta patch, File storage) throws FileNotFoundException {
        this.zip = new ZipOutputStream(new FileOutputStream(storage));
        this.meta = new Meta(patch);
    }

    public PatchAssembler checksum(String path, HashCode md5) {
        this.checksum.add(this.normalize(path), md5);
        return this;
    }

    public PatchAssembler add(String path, InputStream input) {
        HashingInputStream hashing = new HashingInputStream(Hashing.md5(), input);
        this.write("data/" + path, (InputStream)hashing);
        this.index.added(this.normalize(path), hashing.hash());
        return this;
    }

    @Deprecated
    public PatchAssembler add(String path, InputStream input, HashCode md5) throws IOException {
        this.write("data/" + path, input);
        this.index.added(this.normalize(path), md5);
        return this;
    }

    public PatchAssembler update(String path, InputStream input) {
        HashingInputStream hashing = new HashingInputStream(Hashing.md5(), input);
        this.write("data/" + path, (InputStream)hashing);
        this.index.updated(this.normalize(path), hashing.hash());
        return this;
    }

    @Deprecated
    public PatchAssembler update(String path, InputStream input, HashCode md5) throws IOException {
        this.write("data/" + path, input);
        this.index.updated(this.normalize(path), md5);
        return this;
    }

    public PatchAssembler delete(String path) {
        this.index.deleted(this.normalize(path));
        return this;
    }

    private void write(String entry, InputStream input) throws IOException {
        this.zip.putNextEntry(new ZipEntry(entry));
        IOUtils.copy((InputStream)input, (OutputStream)this.zip);
    }

    private void write(ArchivePart part) throws IOException {
        this.zip.putNextEntry(new ZipEntry(part.location()));
        part.writeTo(this.zip);
    }

    private void write() throws IOException {
        this.write(this.meta);
        this.write(this.index);
        this.write(this.checksum);
    }

    @Override
    public void close() throws IOException {
        this.write();
        this.zip.close();
    }

    private String normalize(String path) {
        return FilenameUtils.normalize((String)path, (boolean)true);
    }

    public static interface Assemble {
        public void assemble(PatchAssembler var1) throws IOException;
    }
}

