/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.patch.plusworkflow.archive;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import com.suncode.autoupdate.patch.plusworkflow.archive.ArchivePart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class Index
extends ArchivePart {
    private Map<String, HashCode> added = new LinkedHashMap<String, HashCode>();
    private Map<String, HashCode> updated = new LinkedHashMap<String, HashCode>();
    private Set<String> deleted = new LinkedHashSet<String>();

    public Set<String> getChanged() {
        return ImmutableSet.builder().addAll(this.getAdded()).addAll(this.getUpdated()).addAll(this.getDeleted()).build();
    }

    public HashCode getChecksum(String path) {
        if (this.added.containsKey(path)) {
            return this.getAddedChecksum(path);
        }
        return this.getUpdatedChecksum(path);
    }

    public void added(String path, HashCode md5) {
        this.added.put(path, md5);
    }

    public Set<String> getAdded() {
        return this.added.keySet();
    }

    public HashCode getAddedChecksum(String path) {
        return this.added.get(path);
    }

    public Set<String> getUpdated() {
        return this.updated.keySet();
    }

    public HashCode getUpdatedChecksum(String path) {
        return this.updated.get(path);
    }

    public Set<String> getDeleted() {
        return this.deleted;
    }

    public void updated(String path, HashCode md5) {
        this.updated.put(path, md5);
    }

    public void deleted(String path) {
        this.deleted.add(path);
    }

    public boolean isAdded(String path) {
        return this.added.containsKey(path);
    }

    public boolean isUpdated(String path) {
        return this.updated.containsKey(path);
    }

    public boolean isDeleted(String path) {
        return this.deleted.contains(path);
    }

    public Optional<Change> changeFor(String path) {
        if (this.added.containsKey(path)) {
            return Optional.of(Change.ADDED);
        }
        if (this.deleted.contains(path)) {
            return Optional.of(Change.DELETED);
        }
        if (this.updated.containsKey(path)) {
            return Optional.of(Change.UPDATED);
        }
        return Optional.empty();
    }

    @Override
    public String location() {
        return "index";
    }

    @Override
    protected void writeToProperties(Properties properties) {
        this.writePart(properties, this.added.keySet(), "NEW", this.added);
        this.writePart(properties, this.updated.keySet(), "UPD", this.updated);
        this.writePart(properties, this.deleted, "DEL", null);
    }

    @Override
    protected void readFromProperties(Properties properties) {
        for (String path : properties.stringPropertyNames()) {
            String[] type = properties.getProperty(path).split("@");
            if ("NEW".equals(type[0])) {
                this.added(path, HashCode.fromString((String)type[1]));
                continue;
            }
            if ("UPD".equals(type[0])) {
                this.updated(path, HashCode.fromString((String)type[1]));
                continue;
            }
            if (!"DEL".equals(type[0])) continue;
            this.deleted(path);
        }
    }

    private void writePart(Properties props, Collection<String> paths, String type, Map<String, HashCode> checksums) {
        ArrayList<String> sorted = new ArrayList<String>(paths);
        Collections.sort(sorted);
        for (String path : sorted) {
            HashCode md5 = null;
            if (checksums != null) {
                md5 = checksums.get(path);
            }
            props.setProperty(path, type + (md5 != null ? "@" + md5.toString() : ""));
        }
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.updated.isEmpty() && this.deleted.isEmpty();
    }

    public static enum Change {
        ADDED,
        UPDATED,
        DELETED;

    }
}

