/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlActivityBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlParticipantBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlVariableBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlWorkflowPointBuilder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlProcessBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String name;
    private LocalDateTime created = LocalDateTime.now();
    private String description;
    private final List<XpdlParticipantBuilder> participants = new ArrayList<XpdlParticipantBuilder>();
    private final List<XpdlVariableBuilder> variables = new ArrayList<XpdlVariableBuilder>();
    private final List<XpdlActivityBuilder> activities = new ArrayList<XpdlActivityBuilder>();
    private final List<XpdlTransitionBuilder> transitions = new ArrayList<XpdlTransitionBuilder>();
    private final List<XpdlWorkflowPointBuilder> workflowStarts = new ArrayList<XpdlWorkflowPointBuilder>();
    private final List<XpdlWorkflowPointBuilder> workflowEnds = new ArrayList<XpdlWorkflowPointBuilder>();
    private String attachmentDirectory = UUID.randomUUID().toString();

    private XpdlProcessBuilder(String id, String name) {
        this.id = id;
        this.name = name;
        this.description = name;
    }

    public static XpdlProcessBuilder create(String id, String name) {
        return new XpdlProcessBuilder(id, name);
    }

    public XpdlProcessBuilder withCreated(LocalDateTime created) {
        this.created = created;
        return this;
    }

    public XpdlProcessBuilder withCreated(String created) {
        this.created = LocalDateTime.parse(created, DATE_TIME_FORMATTER);
        return this;
    }

    public XpdlProcessBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public XpdlProcessBuilder addVariable(XpdlVariableBuilder variable) {
        this.variables.add(variable);
        return this;
    }

    public XpdlProcessBuilder addParticipant(XpdlParticipantBuilder participant) {
        this.participants.add(participant);
        return this;
    }

    public XpdlProcessBuilder addActivity(XpdlActivityBuilder activity) {
        this.activities.add(activity);
        return this;
    }

    public XpdlProcessBuilder addTransition(XpdlTransitionBuilder transition) {
        this.transitions.add(transition);
        return this;
    }

    public XpdlProcessBuilder addWorkflowStart(XpdlWorkflowPointBuilder workflowStart) {
        this.workflowStarts.add(workflowStart);
        return this;
    }

    public XpdlProcessBuilder addWorkflowEnd(XpdlWorkflowPointBuilder workflowEnd) {
        this.workflowEnds.add(workflowEnd);
        return this;
    }

    public XpdlProcessBuilder withAttachmentDirectory(String attachmentDirectory) {
        this.attachmentDirectory = attachmentDirectory;
        return this;
    }

    public List<XpdlParticipantBuilder> getParticipants() {
        return new ArrayList<XpdlParticipantBuilder>(this.participants);
    }

    public List<XpdlActivityBuilder> getActivities() {
        return new ArrayList<XpdlActivityBuilder>(this.activities);
    }

    @Override
    public Element buildElement(Document document) {
        Element workflowProcess = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:WorkflowProcess");
        workflowProcess.setAttribute("Id", this.id);
        workflowProcess.setAttribute("Name", this.name);
        Element processHeader = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ProcessHeader");
        Element processCreatedElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Created");
        processCreatedElement.setTextContent(this.formatDateTime(this.created));
        Element descriptionElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        descriptionElement.setTextContent(this.description);
        processHeader.appendChild(processCreatedElement);
        processHeader.appendChild(descriptionElement);
        workflowProcess.appendChild(processHeader);
        workflowProcess.appendChild(this.buildFormalParameters(document));
        Element dataFields = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataFields");
        ArrayList<XpdlVariableBuilder> variablesSorted = new ArrayList<XpdlVariableBuilder>(this.variables);
        variablesSorted.sort(Comparator.comparing(XpdlVariableBuilder::getId));
        for (XpdlVariableBuilder xpdlVariableBuilder : variablesSorted) {
            dataFields.appendChild(xpdlVariableBuilder.buildElement(document));
        }
        workflowProcess.appendChild(dataFields);
        Element participantsElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Participants");
        for (XpdlParticipantBuilder xpdlParticipantBuilder : this.participants) {
            participantsElement.appendChild(xpdlParticipantBuilder.buildElement(document));
        }
        workflowProcess.appendChild(participantsElement);
        Element element = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Activities");
        for (XpdlActivityBuilder activity : this.activities) {
            element.appendChild(activity.buildElement(document));
        }
        workflowProcess.appendChild(element);
        Element element2 = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Transitions");
        for (XpdlTransitionBuilder transition : this.transitions) {
            element2.appendChild(transition.buildElement(document));
        }
        workflowProcess.appendChild(element2);
        workflowProcess.appendChild(this.buildProcessExtendedAttributes(document));
        return workflowProcess;
    }

    private Element buildFormalParameters(Document document) {
        Element formalParameters = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameters");
        Element initiator = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        initiator.setAttribute("Id", "Initiator");
        initiator.setAttribute("Mode", "IN");
        Element initiatorDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element initiatorBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        initiatorBasicType.setAttribute("Type", "STRING");
        initiatorDataType.appendChild(initiatorBasicType);
        Element initiatorDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        initiatorDescription.setTextContent("Inicjator procesu");
        initiator.appendChild(initiatorDataType);
        initiator.appendChild(initiatorDescription);
        formalParameters.appendChild(initiator);
        Element procId = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        procId.setAttribute("Id", "ProccessId");
        procId.setAttribute("Mode", "IN");
        Element procIdDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element procIdBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        procIdBasicType.setAttribute("Type", "STRING");
        procIdDataType.appendChild(procIdBasicType);
        Element procIdDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        procIdDescription.setTextContent("Identyfikator procesu");
        procId.appendChild(procIdDataType);
        procId.appendChild(procIdDescription);
        formalParameters.appendChild(procId);
        Element activityId = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        activityId.setAttribute("Id", "ActivityId");
        activityId.setAttribute("Mode", "IN");
        Element activityIdDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element activityIdBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        activityIdBasicType.setAttribute("Type", "STRING");
        activityIdDataType.appendChild(activityIdBasicType);
        Element activityIdDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        activityIdDescription.setTextContent("Identyfikator zadania");
        activityId.appendChild(activityIdDataType);
        activityId.appendChild(activityIdDescription);
        formalParameters.appendChild(activityId);
        Element transaction = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        transaction.setAttribute("Id", "Transaction");
        transaction.setAttribute("Mode", "IN");
        Element transactionDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element transactionBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        transactionBasicType.setAttribute("Type", "STRING");
        transactionDataType.appendChild(transactionBasicType);
        Element transactionDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        transactionDescription.setTextContent("Transakcja silnika Shark");
        transaction.appendChild(transactionDataType);
        transaction.appendChild(transactionDescription);
        formalParameters.appendChild(transaction);
        Element action = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        action.setAttribute("Id", "Action");
        action.setAttribute("Mode", "INOUT");
        Element actionDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element actionBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        actionBasicType.setAttribute("Type", "STRING");
        actionDataType.appendChild(actionBasicType);
        Element actionDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        actionDescription.setTextContent("Opisuje przekierowanie do zada\u0144");
        action.appendChild(actionDataType);
        action.appendChild(actionDescription);
        formalParameters.appendChild(action);
        Element storageData = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:FormalParameter");
        storageData.setAttribute("Id", "StorageData");
        storageData.setAttribute("Mode", "INOUT");
        Element storageDataDataType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:DataType");
        Element storageDataBasicType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:BasicType");
        storageDataBasicType.setAttribute("Type", "STRING");
        storageDataDataType.appendChild(storageDataBasicType);
        Element storageDataDescription = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Description");
        storageDataDescription.setTextContent("Pe\u0142ni funkcj\u0119 schowka danych w ramach procesu");
        storageData.appendChild(storageDataDataType);
        storageData.appendChild(storageDataDescription);
        formalParameters.appendChild(storageData);
        return formalParameters;
    }

    private Element buildProcessExtendedAttributes(Document document) {
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        StringBuilder participantOrder = new StringBuilder();
        for (int i = 0; i < this.participants.size(); ++i) {
            if (i > 0) {
                participantOrder.append(",");
            }
            participantOrder.append(this.participants.get(i).getId());
        }
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER", participantOrder.toString());
        for (XpdlWorkflowPointBuilder workflowStartBuilder : this.workflowStarts) {
            this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_START_OF_WORKFLOW", workflowStartBuilder.toString());
        }
        for (XpdlWorkflowPointBuilder workflowEndBuilder : this.workflowEnds) {
            this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_END_OF_WORKFLOW", workflowEndBuilder.toString());
        }
        this.addExtendedAttribute(document, extendedAttributes, "PROCESS_NAME_MASK", this.name + "_ VER/#####");
        this.addExtendedAttribute(document, extendedAttributes, "TABLES", "[]");
        this.addExtendedAttribute(document, extendedAttributes, "ATTACHMENT_DIRECTORY", this.attachmentDirectory);
        return extendedAttributes;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public List<XpdlVariableBuilder> getVariables() {
        return this.variables;
    }

    public List<XpdlTransitionBuilder> getTransitions() {
        return this.transitions;
    }

    public List<XpdlWorkflowPointBuilder> getWorkflowStarts() {
        return this.workflowStarts;
    }

    public List<XpdlWorkflowPointBuilder> getWorkflowEnds() {
        return this.workflowEnds;
    }

    public String getAttachmentDirectory() {
        return this.attachmentDirectory;
    }
}

