/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.workflow.process.map.VariableRefType;
import com.suncode.pwfl.xpdl.builder.XpdlAcceptButtonBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionRestrictions;
import com.suncode.pwfl.xpdl.builder.XpdlVariableRefBuilder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlActivityBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String name;
    private final String participantId;
    private final int xOffset;
    private final int yOffset;
    private List<XpdlVariableRefBuilder> variables = new ArrayList<XpdlVariableRefBuilder>();
    private List<XpdlAcceptButtonBuilder> acceptButtons = new ArrayList<XpdlAcceptButtonBuilder>();
    private XpdlTransitionRestrictions transitionRestrictions;

    private XpdlActivityBuilder(String id, String name, String participantId, int xOffset, int yOffset) {
        this.id = id;
        this.name = name;
        this.participantId = participantId;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static XpdlActivityBuilder create(String id, String name, String participantId, int xOffset, int yOffset) {
        return new XpdlActivityBuilder(id, name, participantId, xOffset, yOffset);
    }

    public XpdlActivityBuilder withVariables(List<XpdlVariableRefBuilder> variables) {
        this.variables = new ArrayList<XpdlVariableRefBuilder>(variables);
        return this;
    }

    public XpdlActivityBuilder withAcceptButtons(List<XpdlAcceptButtonBuilder> acceptButtons) {
        this.acceptButtons = new ArrayList<XpdlAcceptButtonBuilder>(acceptButtons);
        return this;
    }

    public XpdlActivityBuilder withTransitionRestrictions(XpdlTransitionRestrictions transitionRestrictions) {
        this.transitionRestrictions = transitionRestrictions;
        return this;
    }

    @Override
    public Element buildElement(Document document) {
        Element activity = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Activity");
        activity.setAttribute("Id", this.id);
        activity.setAttribute("Name", this.name);
        Element implementation = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Implementation");
        Element no = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:No");
        implementation.appendChild(no);
        activity.appendChild(implementation);
        Element performer = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Performer");
        performer.setTextContent(this.participantId);
        activity.appendChild(performer);
        if (this.transitionRestrictions != null) {
            Element transitionRestrictionsElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:TransitionRestrictions");
            activity.appendChild(transitionRestrictionsElement);
            Element transitionRestrictionElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:TransitionRestriction");
            transitionRestrictionsElement.appendChild(transitionRestrictionElement);
            if (this.transitionRestrictions.getJoinType() != null) {
                Element joinTypeElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Join");
                joinTypeElement.setAttribute("Type", this.transitionRestrictions.getJoinType().name());
                transitionRestrictionElement.appendChild(joinTypeElement);
            }
            if (this.transitionRestrictions.getSplitType() != null) {
                Element splitTypeElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Split");
                splitTypeElement.setAttribute("Type", this.transitionRestrictions.getSplitType().name());
                transitionRestrictionElement.appendChild(splitTypeElement);
                if (this.transitionRestrictions.getTransitionRefs() != null) {
                    Element transitionRefsElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:TransitionRefs");
                    splitTypeElement.appendChild(transitionRefsElement);
                    for (String transitionRef : this.transitionRestrictions.getTransitionRefs()) {
                        Element transitionRefElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:TransitionRef");
                        transitionRefElement.setAttribute("Id", transitionRef);
                        transitionRefsElement.appendChild(transitionRefElement);
                    }
                }
            }
        }
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_PARTICIPANT_ID", this.participantId);
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_OFFSET", this.xOffset + "," + this.yOffset);
        for (XpdlVariableRefBuilder variable : this.variables) {
            String extAttrVariableRefType = switch (variable.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case VariableRefType.UPDATE -> "VariableToProcess_UPDATE";
                case VariableRefType.VIEW -> "VariableToProcess_VIEW";
                case VariableRefType.HIDDEN -> "VariableToProcess_HIDDEN";
            };
            this.addExtendedAttribute(document, extendedAttributes, extAttrVariableRefType, variable.getId());
        }
        for (XpdlAcceptButtonBuilder acceptButton : this.acceptButtons) {
            String actionAcceptButtonString = String.format("actionName=%s\nbuttonName=%s\naction1=Action=%s\ncheckForm=FALSE\nsaveBeforeAccept=FALSE\nforwardTo=%s\nfilled=false\nhideFrame=false", acceptButton.getId(), acceptButton.getName(), acceptButton.getId(), acceptButton.getForwardTo());
            this.addExtendedAttribute(document, extendedAttributes, "ACTION_ACCEPT_BUTTON", actionAcceptButtonString);
        }
        this.addExtendedAttribute(document, extendedAttributes, "EVENTS", "{\"FORM\":{},\"VARIABLE\":{},\"GRID\":{},\"DT_BUTTON\":{},\"ACTION_BUTTON\":{},\"ACCEPT_BUTTON\":{}}");
        activity.appendChild(extendedAttributes);
        return activity;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public List<XpdlVariableRefBuilder> getVariables() {
        return this.variables;
    }

    public List<XpdlAcceptButtonBuilder> getAcceptButtons() {
        return this.acceptButtons;
    }

    public XpdlTransitionRestrictions getTransitionRestrictions() {
        return this.transitionRestrictions;
    }
}

