/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.validator;

import com.suncode.pwfl.util.StringUtils;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.condition.Condition;
import com.suncode.pwfl.workflow.process.map.transition.condition.GroupCondition;
import com.suncode.pwfl.workflow.process.map.transition.condition.SimpleCondition;

public class ConditionValidator {
    public static void validateCondition(Condition condition, Process process, Activity sourceActivity) {
        if (condition instanceof SimpleCondition) {
            boolean hasButton;
            SimpleCondition simpleCondition = (SimpleCondition)condition;
            if (StringUtils.isNotBlank(simpleCondition.getAcceptButtonId()) && !(hasButton = sourceActivity.getAcceptButtons().stream().anyMatch(acceptButton -> acceptButton.getId().equals(simpleCondition.getAcceptButtonId())))) {
                throw new RuntimeException(String.format("Accept button with acceptButtonId '%s' not found on source activity.", simpleCondition.getAcceptButtonId()));
            }
            if (StringUtils.isNotBlank(simpleCondition.getVariableId())) {
                String variableId = simpleCondition.getVariableId();
                boolean variableExists = process.getVariables().stream().anyMatch(variable -> variable.getId().equals(variableId));
                if (!variableExists) {
                    throw new RuntimeException(String.format("Variable with variableId: '%s' not found.", variableId));
                }
                if (StringUtils.isBlank(simpleCondition.getValue())) {
                    throw new RuntimeException(String.format("Variable condition for '%s' is missing a value.", variableId));
                }
            }
        }
        if (condition instanceof GroupCondition) {
            GroupCondition groupCondition = (GroupCondition)condition;
            if (groupCondition.getConditions() == null || groupCondition.getConditions().isEmpty()) {
                throw new RuntimeException("A condition group must have a non-empty \"conditions\" array.");
            }
            for (Condition subCondition : groupCondition.getConditions()) {
                ConditionValidator.validateCondition(subCondition, process, sourceActivity);
            }
        }
    }
}

