/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.suncode.pwfl.util.StringUtils;
import com.suncode.pwfl.workflow.process.map.transition.condition.Condition;
import com.suncode.pwfl.workflow.process.map.transition.condition.Operator;

public final class SimpleCondition
extends Condition {
    private String acceptButtonId;
    private String variableId;
    private Operator operator;
    private String value;

    public SimpleCondition(String acceptButtonId) {
        this.acceptButtonId = acceptButtonId;
    }

    public SimpleCondition(String variableId, Operator operator, String value) {
        this.variableId = variableId;
        this.operator = operator;
        this.value = value;
    }

    @Override
    public String toConditionText() {
        String acceptButtonCondition = this.getAcceptButtonCondition();
        String variableCondition = this.getVariableCondition();
        if (acceptButtonCondition != null && variableCondition != null) {
            return String.format("( %s && %s )", acceptButtonCondition, variableCondition);
        }
        if (acceptButtonCondition != null) {
            return acceptButtonCondition;
        }
        return variableCondition != null ? variableCondition : "";
    }

    private String getAcceptButtonCondition() {
        if (StringUtils.isBlank(this.acceptButtonId)) {
            return null;
        }
        return String.format("( Action == '%s' )", this.acceptButtonId);
    }

    private String getVariableCondition() {
        if (StringUtils.isBlank(this.variableId) || StringUtils.isBlank(this.value)) {
            return null;
        }
        return String.format("( %s %s %s )", this.variableId, this.operator.getOperation(), this.value);
    }

    public String getAcceptButtonId() {
        return this.acceptButtonId;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setAcceptButtonId(String acceptButtonId) {
        this.acceptButtonId = acceptButtonId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SimpleCondition() {
    }

    public SimpleCondition(String acceptButtonId, String variableId, Operator operator, String value) {
        this.acceptButtonId = acceptButtonId;
        this.variableId = variableId;
        this.operator = operator;
        this.value = value;
    }
}

