/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.transition.condition;

import com.suncode.pwfl.util.StringUtils;
import com.suncode.pwfl.workflow.process.map.transition.condition.Condition;
import com.suncode.pwfl.workflow.process.map.transition.condition.ConditionJoinType;
import java.util.List;

public final class GroupCondition
extends Condition {
    private ConditionJoinType operator;
    private List<Condition> conditions;

    @Override
    public String toConditionText() {
        if (this.conditions == null || this.conditions.isEmpty()) {
            return "";
        }
        List<String> conditionTexts = this.conditions.stream().map(Condition::toConditionText).filter(StringUtils::isNotBlank).toList();
        if (conditionTexts.isEmpty()) {
            return "";
        }
        if (conditionTexts.size() == 1) {
            return conditionTexts.get(0);
        }
        String delimiter = this.operator == ConditionJoinType.AND ? " && " : " || ";
        String mergedConditionText = String.join((CharSequence)delimiter, conditionTexts);
        return String.format("( %s )", mergedConditionText);
    }

    public ConditionJoinType getOperator() {
        return this.operator;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setOperator(ConditionJoinType operator) {
        this.operator = operator;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public GroupCondition() {
    }

    public GroupCondition(ConditionJoinType operator, List<Condition> conditions) {
        this.operator = operator;
        this.conditions = conditions;
    }
}

