/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.query;

import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.Gateway;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import java.util.List;
import java.util.Optional;

public final class ProcessMapDataQuery {
    private final Process process;

    public Optional<Activity> getActivity(String activityId) {
        return this.process.getActivities().stream().filter(act -> act.getId().equals(activityId)).findFirst();
    }

    public Optional<Transition> getOutgoingTransitionFromActivity(String activityId) {
        return this.process.getTransitions().stream().filter(transition -> transition.getSourceId().equals(activityId)).findFirst();
    }

    public Optional<Gateway> getGatewayTransitionFromActivity(String activityId) {
        Optional<Transition> transition = this.getOutgoingTransitionFromActivity(activityId);
        if (transition.isEmpty()) {
            return Optional.empty();
        }
        Transition outgoingTransition = transition.get();
        return this.process.getGateways().stream().filter(gateway -> gateway.getId().equals(outgoingTransition.getTargetId())).findFirst();
    }

    public List<Transition> getOutgoingTransitionsFromGateway(String gatewayId) {
        return this.process.getTransitions().stream().filter(transition -> transition.getSourceId().equals(gatewayId)).toList();
    }

    public ProcessMapDataQuery(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessMapDataQuery)) {
            return false;
        }
        ProcessMapDataQuery other = (ProcessMapDataQuery)o;
        Process this$process = this.getProcess();
        Process other$process = other.getProcess();
        return !(this$process == null ? other$process != null : !this$process.equals(other$process));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Process $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessMapDataQuery(process=" + String.valueOf(this.getProcess()) + ")";
    }
}

