/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.process.map.builder;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentExecutor;
import com.suncode.pwfl.assistant.agent.main.MainAgent;
import com.suncode.pwfl.assistant.model.AgentConfig;
import com.suncode.pwfl.prompting.LlmService;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.builder.LlmProcessMapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlmProcessMapBuilderImpl
implements LlmProcessMapBuilder {
    private static final Logger log = LoggerFactory.getLogger(LlmProcessMapBuilderImpl.class);
    private final LlmService llmService;

    public LlmProcessMapBuilderImpl(LlmService llmService) {
        this.llmService = llmService;
    }

    @Override
    public Process buildProcessMapFromPrompt(String prompt) {
        AgentConfig config = new AgentConfig(7, "Workflo\u0142ek", "admin");
        AgentContext context = new AgentContext(this.llmService, config);
        AgentExecutor agentExecutor = new AgentExecutor(context);
        MainAgent mainAgent = new MainAgent(context);
        agentExecutor.execute(mainAgent, prompt);
        Process processMap = mainAgent.getState().getProcessMap();
        if (processMap.getId() == null) {
            processMap.setId("proces");
        }
        if (processMap.getName() == null) {
            processMap.setName("Proces");
        }
        return processMap;
    }
}

