/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import java.text.Normalizer;
import java.util.regex.Pattern;

public class IdNormalizer {
    private static final Pattern DIACRITICS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^\\w\\s]");
    private static final Pattern MULTI_WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern MULTI_UNDERSCORE = Pattern.compile("_+");
    private static final Pattern LEADING_DIGITS = Pattern.compile("^\\d+");

    public static String normalize(String input) {
        return IdNormalizer.normalize(input, 30);
    }

    public static String normalize(String input, int limit) {
        String id = input.trim().toLowerCase();
        id = IdNormalizer.stripAccents(id);
        id = IdNormalizer.removeSpecialChars(id);
        id = IdNormalizer.normalizeWhitespace(id);
        id = IdNormalizer.replaceSpacesWithUnderscores(id);
        id = IdNormalizer.collapseMultipleUnderscores(id);
        id = IdNormalizer.trimTrailingUnderscore(id);
        if ((id = IdNormalizer.removeLeadingDigits(id)).length() > limit) {
            id = id.substring(0, limit);
        }
        return id;
    }

    private static String stripAccents(String input) {
        String normalized = Normalizer.normalize(input, Normalizer.Form.NFD);
        return DIACRITICS.matcher(normalized).replaceAll("");
    }

    private static String removeSpecialChars(String input) {
        return NON_ALPHANUMERIC.matcher(input).replaceAll("");
    }

    private static String normalizeWhitespace(String input) {
        return MULTI_WHITESPACE.matcher(input.trim()).replaceAll(" ");
    }

    private static String replaceSpacesWithUnderscores(String input) {
        return input.replace(" ", "_");
    }

    private static String collapseMultipleUnderscores(String input) {
        return MULTI_UNDERSCORE.matcher(input).replaceAll("_");
    }

    private static String trimTrailingUnderscore(String input) {
        int len = input.length();
        return len > 0 && input.charAt(len - 1) == '_' ? input.substring(0, len - 1) : input;
    }

    private static String removeLeadingDigits(String input) {
        return LEADING_DIGITS.matcher(input).replaceAll("");
    }
}

