/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.main.tools.ActivitiesVariablesAgentTool;
import com.suncode.pwfl.assistant.agent.main.tools.FinalAnswerTool;
import com.suncode.pwfl.assistant.agent.main.tools.TransitionsAgentTool;
import com.suncode.pwfl.assistant.agent.transition.tools.AppendOutgoingTransitionToActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.CreateAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteOutgoingTransitionFromActivityTool;
import com.suncode.pwfl.assistant.agent.transition.tools.DeleteTransitionPathsFromGatewayTool;
import com.suncode.pwfl.assistant.agent.transition.tools.GetAcceptButtonsOfActivitiesTool;
import com.suncode.pwfl.assistant.agent.transition.tools.GetOutgoingTransitionOfActivitiesTool;
import com.suncode.pwfl.assistant.agent.transition.tools.SetActivityAsOutgoingTransitionFromSourceActivityIdTool;
import com.suncode.pwfl.assistant.agent.transition.tools.SetGatewayAsOutgoingTransitionFromSourceActivityIdTool;
import com.suncode.pwfl.assistant.agent.transition.tools.UpdateAcceptButtonsOnActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.AnswerToAgentTool;
import com.suncode.pwfl.assistant.agent.variable.tools.AssignVariableToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CheckActivitiesExistByActivityNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CheckVariablesExistByVariableNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CreateActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.CreateVariablesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteVariableAssignmentToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.DeleteVariableTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetAllActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetAllVariablesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetProcessNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.GetVariablesAssignedToActivitiesTool;
import com.suncode.pwfl.assistant.agent.variable.tools.SetProcessNameTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateVariableAssignmentToActivityTool;
import com.suncode.pwfl.assistant.agent.variable.tools.UpdateVariableTool;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolRegistry {
    private static final Logger log = LoggerFactory.getLogger(ToolRegistry.class);
    private final ObjectMapper objectMapper = new AIAssistantObjectMapper();
    private final Map<ToolKey, ToolDefinition> registry = new HashMap<ToolKey, ToolDefinition>();

    public ToolRegistry() {
        this.registerTool(FinalAnswerTool.DEFINITION);
        this.registerTool(ActivitiesVariablesAgentTool.DEFINITION);
        this.registerTool(TransitionsAgentTool.DEFINITION);
        this.registerTool(CreateActivitiesTool.DEFINITION);
        this.registerTool(DeleteActivityTool.DEFINITION);
        this.registerTool(UpdateActivityTool.DEFINITION);
        this.registerTool(GetAllActivitiesTool.DEFINITION);
        this.registerTool(CheckActivitiesExistByActivityNameTool.DEFINITION);
        this.registerTool(CreateVariablesTool.DEFINITION);
        this.registerTool(DeleteVariableTool.DEFINITION);
        this.registerTool(UpdateVariableTool.DEFINITION);
        this.registerTool(GetAllVariablesTool.DEFINITION);
        this.registerTool(CheckVariablesExistByVariableNameTool.DEFINITION);
        this.registerTool(AssignVariableToActivityTool.DEFINITION);
        this.registerTool(DeleteVariableAssignmentToActivityTool.DEFINITION);
        this.registerTool(GetVariablesAssignedToActivitiesTool.DEFINITION);
        this.registerTool(UpdateVariableAssignmentToActivityTool.DEFINITION);
        this.registerTool(SetProcessNameTool.DEFINITION);
        this.registerTool(GetProcessNameTool.DEFINITION);
        this.registerTool(AnswerToAgentTool.DEFINITION);
        this.registerTool(GetOutgoingTransitionOfActivitiesTool.DEFINITION);
        this.registerTool(SetActivityAsOutgoingTransitionFromSourceActivityIdTool.DEFINITION);
        this.registerTool(DeleteOutgoingTransitionFromActivityTool.DEFINITION);
        this.registerTool(AppendOutgoingTransitionToActivityTool.DEFINITION);
        this.registerTool(SetGatewayAsOutgoingTransitionFromSourceActivityIdTool.DEFINITION);
        this.registerTool(DeleteTransitionPathsFromGatewayTool.DEFINITION);
        this.registerTool(CreateAcceptButtonsOnActivityTool.DEFINITION);
        this.registerTool(DeleteAcceptButtonsOnActivityTool.DEFINITION);
        this.registerTool(GetAcceptButtonsOfActivitiesTool.DEFINITION);
        this.registerTool(UpdateAcceptButtonsOnActivityTool.DEFINITION);
        this.registerTool(com.suncode.pwfl.assistant.agent.transition.tools.AnswerToAgentTool.DEFINITION);
    }

    private void registerTool(ToolDefinition definition) {
        this.registry.put(new ToolKey(definition.agentType(), definition.name()), definition);
    }

    public List<ToolDefinition> getToolDefinitionsForAgentType(AgentType agentType) {
        return this.registry.entrySet().stream().filter(entry -> ((ToolKey)entry.getKey()).agentType().equals((Object)agentType)).map(Map.Entry::getValue).toList();
    }

    public Tool createTool(AgentType agentType, String toolName, Map<String, Object> parameters) throws ToolCreationException {
        ToolKey key = new ToolKey(agentType, toolName);
        ToolDefinition toolData = this.registry.get(key);
        if (toolData == null) {
            throw new ToolCreationException("Unknown tool: " + toolName + " for agent type: " + String.valueOf((Object)agentType));
        }
        Class<? extends Tool> toolClass = toolData.toolClass();
        try {
            return (Tool)this.objectMapper.convertValue(parameters, toolClass);
        }
        catch (Exception e) {
            log.error("Failed to create tool: " + toolName + " for agent type: " + String.valueOf((Object)agentType), (Throwable)e);
            throw new ToolCreationException("Failed to create tool: " + toolName, e);
        }
    }

    private record ToolKey(AgentType agentType, String toolName) {
    }

    public static class ToolCreationException
    extends Exception {
        public ToolCreationException(String message) {
            super(message);
        }

        public ToolCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

