/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.phase;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.message.responses.LlmAnalysisResponse;
import com.suncode.pwfl.assistant.model.AgentThoughts;
import com.suncode.pwfl.prompting.LlmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentThinkingPhase {
    private static final Logger log = LoggerFactory.getLogger(AgentThinkingPhase.class);
    private final AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
    private final AgentContext context;
    private final LlmService llmService;

    public AgentThinkingPhase(AgentContext context) {
        this.context = context;
        this.llmService = context.getLlmService();
    }

    public void execute(Agent agent, String thinkingPrompt, String userMessage) throws JsonProcessingException {
        String processMapAnalysisRaw = this.llmService.chat(thinkingPrompt, userMessage);
        if (processMapAnalysisRaw == null || processMapAnalysisRaw.isBlank()) {
            log.warn("Process map analysis returned empty result");
            return;
        }
        LlmAnalysisResponse processMapAnalysisResponse = (LlmAnalysisResponse)this.objectMapper.readValue(processMapAnalysisRaw, (TypeReference)new TypeReference<LlmAnalysisResponse<String>>(){});
        agent.getState().setThoughts(new AgentThoughts((String)processMapAnalysisResponse.getResult()));
        log.trace("[{}][{}] Thinking phase completed: {}", new Object[]{agent, agent.getState().getStep(), processMapAnalysisResponse.getResult()});
    }
}

