/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.phase;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.message.responses.LlmAnalysisResponse;
import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.ActionResult;
import com.suncode.pwfl.assistant.model.AgentActionState;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolRegistry;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.prompting.LlmService;
import com.suncode.pwfl.util.StringUtils;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentActionUsagePhase {
    private static final Logger log = LoggerFactory.getLogger(AgentActionUsagePhase.class);
    private final AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
    private final AgentContext context;
    private final LlmService llmService;
    private final ToolRegistry toolRegistry;

    public AgentActionUsagePhase(AgentContext context) {
        this.context = context;
        this.llmService = context.getLlmService();
        this.toolRegistry = context.getToolRegistry();
    }

    public void execute(Agent agent, String userMessage) {
        LlmAnalysisResponse useActionThoughts;
        AgentState state = agent.getState();
        if (StringUtils.isBlank(state.getTask()) || StringUtils.isBlank(state.getAction())) {
            return;
        }
        String actionUsePrompt = agent.getActionUsePrompt();
        String useActionThoughtsRaw = this.llmService.chat(actionUsePrompt, userMessage);
        log.trace("[{}][{}] Action usage phase completed: {}", new Object[]{agent, agent.getState().getStep(), useActionThoughtsRaw});
        Optional<Task> foundTask = agent.getState().getTasks().stream().filter(task -> task.getUuid().equals(state.getTask())).findFirst();
        if (foundTask.isEmpty()) {
            log.warn("[{}][{}] Could not find task by uuid: {}", new Object[]{agent, agent.getState().getStep(), state.getTask()});
            return;
        }
        Optional<Action> foundAction = foundTask.get().getActions().stream().filter(action -> action.getUuid().equals(state.getAction())).findFirst();
        if (foundAction.isEmpty()) {
            log.warn("[{}][{}] Could not find action by uuid: {}", new Object[]{agent, agent.getState().getStep(), state.getAction()});
            return;
        }
        Action action2 = foundAction.get();
        String toolName = action2.getToolName();
        try {
            useActionThoughts = (LlmAnalysisResponse)this.objectMapper.readValue(useActionThoughtsRaw, (TypeReference)new TypeReference<LlmAnalysisResponse<Map<String, Object>>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("[{}][{}] Failed to create tool: {}", new Object[]{agent, agent.getState().getStep(), toolName, e});
            action2.setResult(new ActionResult(false, String.format("Error: Tool %s creation failed: %s", toolName, "Failed to create tool: " + toolName), "failed"));
            action2.setState(AgentActionState.FAILED);
            action2.setUpdated(LocalDateTime.now());
            return;
        }
        Map toolParameters = (Map)useActionThoughts.getResult();
        this.executeTool(action2, toolName, toolParameters, agent, userMessage);
    }

    private void executeTool(Action action, String toolName, Map<String, Object> payload, Agent agent, String userMessage) {
        try {
            log.info("[{}][{}] Invoking tool [{}]", new Object[]{agent, agent.getState().getStep(), toolName});
            Tool tool = this.toolRegistry.createTool(agent.getAgentType(), toolName, payload);
            ToolContext toolContext = new ToolContext(this.context, agent.getState(), userMessage);
            ToolResult result = tool.execute(toolContext);
            action.setResult(new ActionResult(result.success(), result.data(), result.success() ? "success" : "failed"));
            action.setState(result.success() ? AgentActionState.COMPLETED : AgentActionState.FAILED);
            action.setUpdated(LocalDateTime.now());
            log.trace("[{}][{}] Invoked tool [{}] with result: {}", new Object[]{agent, agent.getState().getStep(), toolName, result.data()});
        }
        catch (ToolRegistry.ToolCreationException e) {
            log.error("[{}][{}] Failed to create tool: {}", new Object[]{agent, agent.getState().getStep(), toolName, e});
            action.setResult(new ActionResult(false, String.format("Error: Tool %s creation failed: %s", toolName, e.getMessage()), "failed"));
            action.setState(AgentActionState.FAILED);
            action.setUpdated(LocalDateTime.now());
        }
    }
}

