/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.model;

import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.AgentTaskState;
import java.time.LocalDateTime;
import java.util.List;

public class Task {
    private String uuid;
    private String conversationUuid;
    private String name;
    private String toolName;
    private AgentTaskState state;
    private List<Action> actions;
    private String description;
    private LocalDateTime created;
    private LocalDateTime updated;
    private Integer failureCount;

    public void incrementFailureCount() {
        this.failureCount = this.failureCount != null ? this.failureCount + 1 : 1;
    }

    Task(String uuid, String conversationUuid, String name, String toolName, AgentTaskState state, List<Action> actions, String description, LocalDateTime created, LocalDateTime updated, Integer failureCount) {
        this.uuid = uuid;
        this.conversationUuid = conversationUuid;
        this.name = name;
        this.toolName = toolName;
        this.state = state;
        this.actions = actions;
        this.description = description;
        this.created = created;
        this.updated = updated;
        this.failureCount = failureCount;
    }

    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getConversationUuid() {
        return this.conversationUuid;
    }

    public String getName() {
        return this.name;
    }

    public String getToolName() {
        return this.toolName;
    }

    public AgentTaskState getState() {
        return this.state;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getDescription() {
        return this.description;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setState(AgentTaskState state) {
        this.state = state;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public static class TaskBuilder {
        private String uuid;
        private String conversationUuid;
        private String name;
        private String toolName;
        private AgentTaskState state;
        private List<Action> actions;
        private String description;
        private LocalDateTime created;
        private LocalDateTime updated;
        private Integer failureCount;

        TaskBuilder() {
        }

        public TaskBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public TaskBuilder conversationUuid(String conversationUuid) {
            this.conversationUuid = conversationUuid;
            return this;
        }

        public TaskBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskBuilder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public TaskBuilder state(AgentTaskState state) {
            this.state = state;
            return this;
        }

        public TaskBuilder actions(List<Action> actions) {
            this.actions = actions;
            return this;
        }

        public TaskBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TaskBuilder created(LocalDateTime created) {
            this.created = created;
            return this;
        }

        public TaskBuilder updated(LocalDateTime updated) {
            this.updated = updated;
            return this;
        }

        public TaskBuilder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public Task build() {
            return new Task(this.uuid, this.conversationUuid, this.name, this.toolName, this.state, this.actions, this.description, this.created, this.updated, this.failureCount);
        }

        public String toString() {
            return "Task.TaskBuilder(uuid=" + this.uuid + ", conversationUuid=" + this.conversationUuid + ", name=" + this.name + ", toolName=" + this.toolName + ", state=" + String.valueOf((Object)this.state) + ", actions=" + String.valueOf(this.actions) + ", description=" + this.description + ", created=" + String.valueOf(this.created) + ", updated=" + String.valueOf(this.updated) + ", failureCount=" + this.failureCount + ")";
        }
    }
}

