/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.model;

import com.suncode.pwfl.assistant.model.ActionResult;
import com.suncode.pwfl.assistant.model.AgentActionState;
import java.time.LocalDateTime;

public class Action {
    String uuid;
    String taskUuid;
    String name;
    String toolName;
    AgentActionState state;
    LocalDateTime created;
    LocalDateTime updated;
    ActionResult result;

    Action(String uuid, String taskUuid, String name, String toolName, AgentActionState state, LocalDateTime created, LocalDateTime updated, ActionResult result) {
        this.uuid = uuid;
        this.taskUuid = taskUuid;
        this.name = name;
        this.toolName = toolName;
        this.state = state;
        this.created = created;
        this.updated = updated;
        this.result = result;
    }

    public static ActionBuilder builder() {
        return new ActionBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getTaskUuid() {
        return this.taskUuid;
    }

    public String getName() {
        return this.name;
    }

    public String getToolName() {
        return this.toolName;
    }

    public AgentActionState getState() {
        return this.state;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public ActionResult getResult() {
        return this.result;
    }

    public void setState(AgentActionState state) {
        this.state = state;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public void setResult(ActionResult result) {
        this.result = result;
    }

    public static class ActionBuilder {
        private String uuid;
        private String taskUuid;
        private String name;
        private String toolName;
        private AgentActionState state;
        private LocalDateTime created;
        private LocalDateTime updated;
        private ActionResult result;

        ActionBuilder() {
        }

        public ActionBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public ActionBuilder taskUuid(String taskUuid) {
            this.taskUuid = taskUuid;
            return this;
        }

        public ActionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ActionBuilder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public ActionBuilder state(AgentActionState state) {
            this.state = state;
            return this;
        }

        public ActionBuilder created(LocalDateTime created) {
            this.created = created;
            return this;
        }

        public ActionBuilder updated(LocalDateTime updated) {
            this.updated = updated;
            return this;
        }

        public ActionBuilder result(ActionResult result) {
            this.result = result;
            return this;
        }

        public Action build() {
            return new Action(this.uuid, this.taskUuid, this.name, this.toolName, this.state, this.created, this.updated, this.result);
        }

        public String toString() {
            return "Action.ActionBuilder(uuid=" + this.uuid + ", taskUuid=" + this.taskUuid + ", name=" + this.name + ", toolName=" + this.toolName + ", state=" + String.valueOf((Object)this.state) + ", created=" + String.valueOf(this.created) + ", updated=" + String.valueOf(this.updated) + ", result=" + String.valueOf(this.result) + ")";
        }
    }
}

