/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.VariableType;
import java.lang.invoke.CallSite;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateVariableTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "update_variable", "Updates one or more variables in the process map. Variables are used solely for storing data and displaying it on a form. For each variable, if a new name is provided, a new variableId is generated, and all assignments to activities are updated with the new variableId. Returns the updated variables in the following format: { \"updatedVariables\": [ { \"oldVariableId\": \"<old id>\", \"newVariableId\": \"<new id>\", \"newVariableName\": \"<new name>\", \"newVariableType\": \"<new type>\" } ] }\n", "To update variables, write { \"variables\": [ { \"variableId\": \"<id to update>\", \"newVariableName\": \"<new name>\", \"newVariableType\": \"<new type>\" } ] }. The payload for each variable MUST be in the nominative case, for example: Invoice number, Invoice date, Invoice amount. Allowed variable types: 'STRING', 'INTEGER', 'FLOAT', 'BOOLEAN', 'DATE', 'DATE_TIME'", UpdateVariableTool.class);
    private final List<VariableToUpdate> variables;

    @JsonCreator
    public UpdateVariableTool(@JsonProperty(value="variables") List<VariableToUpdate> variables) {
        this.variables = variables;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        Variable variable;
        if (this.variables == null || this.variables.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"variables\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<UpdatedVariableInfo> updatedVariables = new ArrayList<UpdatedVariableInfo>();
        ArrayList<CallSite> typeUpdateResults = new ArrayList<CallSite>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        HashMap<String, String> idChanges = new HashMap<String, String>();
        for (VariableToUpdate variableUpdate : this.variables) {
            variable = process.getVariables().stream().filter(v -> v.getId().equals(variableUpdate.getVariableId())).findFirst().orElse(null);
            if (variable == null) {
                errors.add((CallSite)((Object)("Error: Variable with variableId: '" + variableUpdate.getVariableId() + "' doesn't exist!.")));
                continue;
            }
            if (variableUpdate.getNewVariableName() == null || variableUpdate.getNewVariableName().isBlank()) continue;
            String newVariableId = this.generateUniqueVariableId(process, variableUpdate.getNewVariableName(), variable.getId(), idChanges);
            idChanges.put(variable.getId(), newVariableId);
        }
        if (errors.isEmpty()) {
            for (VariableToUpdate variableUpdate : this.variables) {
                variable = process.getVariables().stream().filter(v -> v.getId().equals(variableUpdate.getVariableId())).findFirst().orElse(null);
                if (variable == null) continue;
                String oldVariableId = variable.getId();
                int assignmentsUpdatedCount = 0;
                if (variableUpdate.getNewVariableName() != null && !variableUpdate.getNewVariableName().isBlank()) {
                    String newVariableId = (String)idChanges.get(oldVariableId);
                    variable.setName(variableUpdate.getNewVariableName());
                    variable.setId(newVariableId);
                    for (Activity activity : process.getActivities()) {
                        for (VariableRef variableRef : activity.getVariableRefs()) {
                            if (!variableRef.getId().equals(oldVariableId)) continue;
                            variableRef.setId(newVariableId);
                            ++assignmentsUpdatedCount;
                        }
                    }
                    updatedVariables.add(new UpdatedVariableInfo(oldVariableId, newVariableId, variableUpdate.getNewVariableName(), variableUpdate.getNewVariableType() != null ? variableUpdate.getNewVariableType().name() : null, assignmentsUpdatedCount));
                }
                if (variableUpdate.getNewVariableType() == null) continue;
                variable.setType(variableUpdate.getNewVariableType());
                if (variableUpdate.getNewVariableName() != null && !variableUpdate.getNewVariableName().isBlank()) continue;
                typeUpdateResults.add((CallSite)((Object)("Variable with variableId '" + oldVariableId + "' updated successfully. New variableType is '" + String.valueOf((Object)variableUpdate.getNewVariableType()) + "'.")));
            }
        }
        Object data = "";
        if (updatedVariables.size() > 0) {
            String formattedUpdates = updatedVariables.stream().map(v -> "Variable updated. Old variableId: '" + v.oldVariableId() + "', New variableName: '" + v.newVariableName() + "', New variableId: '" + v.newVariableId() + "'. " + (String)(v.newVariableType() != null ? "New variableType: '" + v.newVariableType() + "'. " : "") + "Updated " + v.assignmentsUpdatedCount() + " assignment(s).").reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
            data = (String)data + "Successfully updated " + updatedVariables.size() + " variables:\n" + formattedUpdates;
        }
        if (typeUpdateResults.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n";
            }
            data = (String)data + String.join((CharSequence)"\n", typeUpdateResults);
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Encountered errors:\n" + String.join((CharSequence)"\n", errors);
        }
        return new ToolResult(updatedVariables.size() > 0 || typeUpdateResults.size() > 0, (String)(((String)data).isEmpty() ? "No variables were updated." : data));
    }

    private String generateUniqueVariableId(Process process, String variableName, String currentVariableId, Map<String, String> idChanges) {
        String baseVariableId = Normalizer.normalize(variableName, Normalizer.Form.NFD).toLowerCase().replaceAll("[\\u0300-\\u036f]", "").replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        if (baseVariableId.length() > 16) {
            baseVariableId = baseVariableId.substring(0, 16);
        }
        String baseId = baseVariableId;
        Object newVariableId = baseId;
        int counter = 1;
        while (true) {
            boolean isIdTaken;
            String currentId = newVariableId;
            boolean bl = isIdTaken = process.getVariables().stream().anyMatch(v -> v.getId().equals(currentId) && !v.getId().equals(currentVariableId)) || idChanges.values().stream().anyMatch(id -> id.equals(currentId));
            if (!isIdTaken) break;
            String counterStr = String.valueOf(counter);
            int maxLength = 16 - counterStr.length();
            String trimmedId = baseId.length() > maxLength ? baseId.substring(0, maxLength) : baseId;
            newVariableId = trimmedId + counter;
            ++counter;
        }
        return newVariableId;
    }

    public List<VariableToUpdate> getVariables() {
        return this.variables;
    }

    public static class VariableToUpdate {
        @JsonProperty(required=true)
        private String variableId;
        @JsonProperty
        private String newVariableName;
        @JsonProperty
        private VariableType newVariableType;

        public String getVariableId() {
            return this.variableId;
        }

        public String getNewVariableName() {
            return this.newVariableName;
        }

        public VariableType getNewVariableType() {
            return this.newVariableType;
        }

        @JsonProperty(required=true)
        public void setVariableId(String variableId) {
            this.variableId = variableId;
        }

        @JsonProperty
        public void setNewVariableName(String newVariableName) {
            this.newVariableName = newVariableName;
        }

        @JsonProperty
        public void setNewVariableType(VariableType newVariableType) {
            this.newVariableType = newVariableType;
        }

        public VariableToUpdate(String variableId, String newVariableName, VariableType newVariableType) {
            this.variableId = variableId;
            this.newVariableName = newVariableName;
            this.newVariableType = newVariableType;
        }

        public VariableToUpdate() {
        }
    }

    private record UpdatedVariableInfo(String oldVariableId, String newVariableId, String newVariableName, String newVariableType, int assignmentsUpdatedCount) {
    }
}

