/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.VariableRefType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class UpdateVariableAssignmentToActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "update_variable_assignment_to_activity", "Updates one or more variable assignments on a specific activity. Returns the updated assignments in the following format: { \"results\": [ { \"activityId\": \"<id>\", \"variableId\": \"<id>\", \"visibilityType\": \"<type>\", \"status\": \"success|failed\", \"message\": \"<message>\" } ] }", "To update variable assignments on an activity, write { \"activityId\": \"<id>\", \"variables\": [ { \"variableId\": \"<id>\", \"visibilityType\": \"<type>\" } ] }. Allowed visibility types are 'UPDATE', 'VIEW', 'HIDDEN'. \nVisibility types description:\n- UPDATE: makes variable editable and visible\n- VIEW: makes variable not editable and visible\n- HIDDEN: makes variable editable and not visible", UpdateVariableAssignmentToActivityTool.class);
    private final String activityId;
    private final List<VariableRefToUpdate> variables;

    @JsonCreator
    public UpdateVariableAssignmentToActivityTool(@JsonProperty(value="activityId") String activityId, @JsonProperty(value="variables") List<VariableRefToUpdate> variables) {
        this.activityId = activityId;
        this.variables = variables;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityId == null || this.activityId.isBlank() || this.variables == null || this.variables.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with \"activityId\" and a non-empty \"variables\" array.");
        }
        Process process = toolContext.getProcess();
        Optional<Activity> activityOpt = process.getActivities().stream().filter(act -> act.getId().equals(this.activityId)).findFirst();
        if (activityOpt.isEmpty()) {
            return new ToolResult(false, "Error: Activity with activityId: '" + this.activityId + "' doesn't exist!.");
        }
        Activity activity = activityOpt.get();
        ArrayList<UpdateResult> results = new ArrayList<UpdateResult>();
        for (VariableRefToUpdate variableRefToUpdate : this.variables) {
            String variableId = variableRefToUpdate.getVariableId();
            VariableRefType visibilityType = variableRefToUpdate.getVariableRefType();
            Optional<VariableRef> variableRefOptional = activity.getVariableRefs().stream().filter(variableRef -> variableRef.getId().equals(variableId)).findFirst();
            if (variableRefOptional.isEmpty()) {
                results.add(new UpdateResult(this.activityId, variableId, visibilityType.name(), "failed", "Error: Variable with variableId: '" + variableId + "' is not assigned to activity with activityId: '" + this.activityId + "'."));
                continue;
            }
            VariableRef variableRef2 = variableRefOptional.get();
            variableRef2.setType(visibilityType);
            results.add(new UpdateResult(this.activityId, variableId, visibilityType.name(), "success", "Successfully updated assignment of variable with variableId: '" + variableId + "' on activity with activityId: '" + this.activityId + "' to visibilityType: '" + String.valueOf((Object)visibilityType) + "'."));
        }
        String formattedData = results.stream().map(r -> "activityId: " + r.activityId() + ", variableId: " + r.variableId() + ", status: " + r.status() + ", message: " + r.message()).reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
        boolean isSuccess = results.stream().anyMatch(r -> "success".equals(r.status()));
        return new ToolResult(isSuccess, "Update results:\n" + formattedData);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public List<VariableRefToUpdate> getVariables() {
        return this.variables;
    }

    public static class VariableRefToUpdate {
        @JsonProperty(required=true)
        private String variableId;
        @JsonProperty(required=true)
        private VariableRefType variableRefType;

        public String getVariableId() {
            return this.variableId;
        }

        public VariableRefType getVariableRefType() {
            return this.variableRefType;
        }

        @JsonProperty(required=true)
        public void setVariableId(String variableId) {
            this.variableId = variableId;
        }

        @JsonProperty(required=true)
        public void setVariableRefType(VariableRefType variableRefType) {
            this.variableRefType = variableRefType;
        }

        public VariableRefToUpdate(String variableId, VariableRefType variableRefType) {
            this.variableId = variableId;
            this.variableRefType = variableRefType;
        }

        public VariableRefToUpdate() {
        }
    }

    private record UpdateResult(String activityId, String variableId, String visibilityType, String status, String message) {
    }
}

