/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import java.lang.invoke.CallSite;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "update_activity", "Updates one or more activities in the process map. A new activityId is generated for each activity based on its new name, and all associated transitions are updated with the new activityId. Returns the updated activities in the following format: { \"updatedActivities\": [ { \"oldActivityId\": \"<old id>\", \"newActivityId\": \"<new id>\", \"newActivityName\": \"<new name>\" } ] }\n", "To update activities, write { \"activities\": [ { \"activityId\": \"<id to update>\", \"newActivityName\": \"<new name>\" } ] }.", UpdateActivityTool.class);
    private final List<ActivityNameUpdate> activities;

    @JsonCreator
    public UpdateActivityTool(@JsonProperty(value="activities") List<ActivityNameUpdate> activities) {
        this.activities = activities;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        Activity activity;
        if (this.activities == null || this.activities.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"activities\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<ActivityNameUpdateResult> updatedActivities = new ArrayList<ActivityNameUpdateResult>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        HashMap<String, String> idChanges = new HashMap<String, String>();
        for (ActivityNameUpdate activityUpdate : this.activities) {
            activity = process.getActivities().stream().filter(act -> act.getId().equals(activityUpdate.getActivityId())).findFirst().orElse(null);
            if (activity == null) {
                errors.add((CallSite)((Object)("Error: Activity with activityId: '" + activityUpdate.getActivityId() + "' doesn't exist!.")));
                continue;
            }
            if (activityUpdate.getNewActivityName() == null || activityUpdate.getNewActivityName().isBlank()) {
                errors.add((CallSite)((Object)("Error: newActivityName is required for activityId: '" + activityUpdate.getActivityId() + "'.")));
                continue;
            }
            String newActivityId = this.generateUniqueActivityId(process, activityUpdate.getNewActivityName(), activity.getId(), idChanges);
            idChanges.put(activity.getId(), newActivityId);
        }
        if (errors.isEmpty()) {
            for (ActivityNameUpdate activityUpdate : this.activities) {
                activity = process.getActivities().stream().filter(act -> act.getId().equals(activityUpdate.getActivityId())).findFirst().orElse(null);
                if (activity == null) continue;
                String oldActivityId = activity.getId();
                String newActivityId = (String)idChanges.get(oldActivityId);
                activity.setName(activityUpdate.getNewActivityName());
                activity.setId(newActivityId);
                updatedActivities.add(new ActivityNameUpdateResult(oldActivityId, newActivityId, activityUpdate.getNewActivityName()));
            }
            for (Transition transition : process.getTransitions()) {
                if (idChanges.containsKey(transition.getSourceId())) {
                    transition.setSourceId((String)idChanges.get(transition.getSourceId()));
                }
                if (!idChanges.containsKey(transition.getTargetId())) continue;
                transition.setTargetId((String)idChanges.get(transition.getTargetId()));
            }
        }
        Object data = "";
        if (updatedActivities.size() > 0) {
            String formattedUpdated = updatedActivities.stream().map(u -> "Activity updated. Old activityId: '" + u.oldActivityId() + "', New activityName: '" + u.newActivityName() + "', New activityId: '" + u.newActivityId() + "'.").reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
            data = (String)data + "Successfully updated " + updatedActivities.size() + " activities:\n" + formattedUpdated;
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Encountered errors:\n" + String.join((CharSequence)"\n", errors);
        }
        return new ToolResult(updatedActivities.size() > 0, (String)(((String)data).isEmpty() ? "No activities were updated." : data));
    }

    private String generateUniqueActivityId(Process process, String activityName, String currentActivityId, Map<String, String> idChanges) {
        String baseActivityId = Normalizer.normalize(activityName, Normalizer.Form.NFD).toLowerCase().replaceAll("[\\u0300-\\u036f]", "").replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        if (baseActivityId.length() > 16) {
            baseActivityId = baseActivityId.substring(0, 16);
        }
        String baseId = baseActivityId;
        Object newActivityId = baseId;
        int counter = 1;
        while (true) {
            boolean isIdTaken;
            String currentId = newActivityId;
            boolean bl = isIdTaken = process.getActivities().stream().anyMatch(a -> a.getId().equals(currentId) && !a.getId().equals(currentActivityId)) || idChanges.values().stream().anyMatch(id -> id.equals(currentId));
            if (!isIdTaken) break;
            String counterStr = String.valueOf(counter);
            int maxLength = 16 - counterStr.length();
            String trimmedId = baseId.length() > maxLength ? baseId.substring(0, maxLength) : baseId;
            newActivityId = trimmedId + counter;
            ++counter;
        }
        return newActivityId;
    }

    public List<ActivityNameUpdate> getActivities() {
        return this.activities;
    }

    public static class ActivityNameUpdate {
        @JsonProperty(required=true)
        private String activityId;
        @JsonProperty(required=true)
        private String newActivityName;

        public String getActivityId() {
            return this.activityId;
        }

        public String getNewActivityName() {
            return this.newActivityName;
        }

        @JsonProperty(required=true)
        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @JsonProperty(required=true)
        public void setNewActivityName(String newActivityName) {
            this.newActivityName = newActivityName;
        }

        public ActivityNameUpdate(String activityId, String newActivityName) {
            this.activityId = activityId;
            this.newActivityName = newActivityName;
        }

        public ActivityNameUpdate() {
        }
    }

    private record ActivityNameUpdateResult(String oldActivityId, String newActivityId, String newActivityName) {
    }
}

