/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Process;
import java.text.Normalizer;

public class SetProcessNameTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "set_process_name", "Sets the name of the process map and generates a unique processId based on the name. Returns the updated process name and id in the following format: { \"processName\": \"<name>\", \"processId\": \"<id>\" }", "To set the process name write { \"processName\": \"<name>\". } \nPayload of the process name MUST be in the nominative case, for example: Invoice process, Requisition process, Outgoing correspondence process. The processId is generated automatically based on the processName.", SetProcessNameTool.class);
    private final String processName;

    @JsonCreator
    public SetProcessNameTool(@JsonProperty(value="processName") String processName) {
        this.processName = processName;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.processName == null || this.processName.isBlank()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"processName\".");
        }
        Process process = toolContext.getProcess();
        String processId = Normalizer.normalize(this.processName, Normalizer.Form.NFD).toLowerCase().replaceAll("[\\u0300-\\u036f]", "").replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        if (processId.length() > 16) {
            processId = processId.substring(0, 16);
        }
        process.setId(processId);
        process.setName(this.processName);
        return new ToolResult(true, "ProcessName set to: '" + this.processName + "' and processId generated: '" + processId + "'.");
    }

    public String getProcessName() {
        return this.processName;
    }
}

