/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GetVariablesAssignedToActivitiesTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "get_variables_assigned_to_activities", "Returns all variables assigned to one or more activities. Returns a list of activities with their assigned variables in the following format: { \"activities\": [ { \"activityId\": \"<id>\", \"assignedVariables\": [ { \"variableId\": \"<id>\", \"visibilityType\": \"<type>\" } ] } ] }", "To get all variables assigned to activities write { \"activityIds\": [\"<id1>\", \"<id2>\"] }.", GetVariablesAssignedToActivitiesTool.class);
    private final List<String> activityIds;

    @JsonCreator
    public GetVariablesAssignedToActivitiesTool(@JsonProperty(value="activityIds") List<String> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityIds == null || this.activityIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"activityIds\" array of strings.");
        }
        Process process = toolContext.getProcess();
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String activityId : this.activityIds) {
            Optional<Activity> activityOpt = process.getActivities().stream().filter(activity -> activity.getId().equals(activityId)).findFirst();
            if (activityOpt.isEmpty()) {
                errors.add((CallSite)((Object)("Error: Activity with activityId: '" + activityId + "' doesn't exist!.")));
                continue;
            }
            Activity activity2 = activityOpt.get();
            if (activity2.getVariableRefs().isEmpty()) {
                results.add((CallSite)((Object)("Activity '" + activityId + "': No variables assigned yet.")));
                continue;
            }
            Object formattedVariables = "";
            int index = 1;
            for (VariableRef variableRef : activity2.getVariableRefs()) {
                if (!((String)formattedVariables).isEmpty()) {
                    formattedVariables = (String)formattedVariables + "\n";
                }
                formattedVariables = (String)formattedVariables + "  " + index + ". variableId: " + variableRef.getId() + ", visibilityType: " + String.valueOf((Object)variableRef.getType());
                ++index;
            }
            results.add((CallSite)((Object)("Activity '" + activityId + "':\n" + (String)formattedVariables)));
        }
        Object data = "";
        if (results.size() > 0) {
            data = (String)data + "Successfully retrieved assigned variables:\n" + String.join((CharSequence)"\n", results);
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Errors:\n" + String.join((CharSequence)"\n", errors);
        }
        if (results.isEmpty() && errors.size() > 0) {
            return new ToolResult(false, (String)data);
        }
        return new ToolResult(true, (String)(((String)data).isEmpty() ? "No activities found or processed." : data));
    }

    public List<String> getActivityIds() {
        return this.activityIds;
    }
}

