/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Process;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class GetProcessNameTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "get_process_name", "Gets information about the process. Returns the processId and processName in the following format: { \"processId\": \"<id>\", \"processName\": \"<name>\" }", "To get process info write {}.", GetProcessNameTool.class);

    @JsonCreator
    public GetProcessNameTool() {
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        Process process = toolContext.getProcess();
        String processId = process.getId();
        String processName = process.getName();
        if ((processId == null || processId.isBlank()) && (processName == null || processName.isBlank())) {
            return new ToolResult(true, "Process info is not set.");
        }
        ArrayList<CallSite> info = new ArrayList<CallSite>();
        if (processId != null && !processId.isBlank()) {
            info.add((CallSite)((Object)("processId: " + processId)));
        }
        if (processName != null && !processName.isBlank()) {
            info.add((CallSite)((Object)("processName: " + processName)));
        }
        return new ToolResult(true, "Successfully retrieved process info: " + String.join((CharSequence)", ", info));
    }
}

