/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;

public class GetAllVariablesTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "get_all_variables", "Returns all variables that are currently added to the process map. Variables are used solely for storing data and displaying it on a form. Returns the variables in the following format: { \"variables\": [ { \"variableId\": \"<id>\", \"variableName\": \"<name>\", \"variableType\": \"<type>\" } ] }. Before using this tool, make sure that you really need to use it. This tool can return a lot of data and it can be difficult to read. If user query is not related to all variables, use check_variables_exist_by_variableName tool instead.\n", "To get all variables write {}.", GetAllVariablesTool.class);

    @JsonCreator
    public GetAllVariablesTool() {
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        Process process = toolContext.getProcess();
        if (process.getVariables().isEmpty()) {
            return new ToolResult(true, "No variables have been added yet on the process map.");
        }
        Object formattedData = "";
        int index = 1;
        for (Variable variable : process.getVariables()) {
            if (!((String)formattedData).isEmpty()) {
                formattedData = (String)formattedData + "\n";
            }
            formattedData = (String)formattedData + index + ". variableId: " + variable.getId() + ", variableName: " + variable.getName() + ", variableType: " + String.valueOf((Object)variable.getType());
            ++index;
        }
        return new ToolResult(true, "Successfully retrieved all variables on the process map:\n" + (String)formattedData);
    }
}

