/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteVariableTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "delete_variable", "Deletes one or more variables from the process map. Returns the deleted variable IDs in the following format: { \"deletedVariableIds\": [\"<id1>\", \"<id2>\"] }", "To delete variables write { \"variableIds\": [\"<id1>\", \"<id2>\"] }.", DeleteVariableTool.class);
    private final List<String> variableIds;

    @JsonCreator
    public DeleteVariableTool(@JsonProperty(value="variableIds") List<String> variableIds) {
        this.variableIds = variableIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.variableIds == null || this.variableIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"variableIds\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<String> deletedIds = new ArrayList<String>();
        ArrayList<String> notFoundIds = new ArrayList<String>();
        HashSet<String> idsToDelete = new HashSet<String>(this.variableIds);
        HashSet currentVariableIds = new HashSet();
        process.getVariables().forEach(v -> currentVariableIds.add(v.getId()));
        for (String id : idsToDelete) {
            if (currentVariableIds.contains(id)) {
                deletedIds.add(id);
                continue;
            }
            notFoundIds.add(id);
        }
        if (deletedIds.size() > 0) {
            process.getVariables().removeIf(variable -> idsToDelete.contains(variable.getId()));
            for (Activity activity : process.getActivities()) {
                activity.getVariableRefs().removeIf(variableRef -> idsToDelete.contains(variableRef.getId()));
            }
        }
        Object data = "";
        if (deletedIds.size() > 0) {
            data = (String)data + "Successfully deleted variables with variableId's: " + String.join((CharSequence)", ", deletedIds) + ".";
        }
        if (notFoundIds.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n";
            }
            data = (String)data + "Variables with the following variableId's were not found: " + String.join((CharSequence)", ", notFoundIds) + ".";
        }
        if (deletedIds.isEmpty() && !notFoundIds.isEmpty()) {
            return new ToolResult(false, "No variables deleted. Variables with the following variableId's were not found: " + String.join((CharSequence)", ", notFoundIds) + ".");
        }
        return new ToolResult(true, (String)data);
    }

    public List<String> getVariableIds() {
        return this.variableIds;
    }
}

