/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DeleteVariableAssignmentToActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "delete_variable_assignment_to_activity", "Deletes one or more variable assignments from a specific activity. Returns the results of the deletion in the following format: { \"results\": [ { \"activityId\": \"<id>\", \"variableId\": \"<id>\", \"status\": \"success|failed\", \"message\": \"<message>\" } ] }", "To delete variable assignments from an activity, write { \"activityId\": \"<id>\", \"variableIds\": [\"<id1>\", \"<id2>\"] }.", DeleteVariableAssignmentToActivityTool.class);
    private final String activityId;
    private final List<String> variableIds;

    @JsonCreator
    public DeleteVariableAssignmentToActivityTool(@JsonProperty(value="activityId") String activityId, @JsonProperty(value="variableIds") List<String> variableIds) {
        this.activityId = activityId;
        this.variableIds = variableIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityId == null || this.activityId.isBlank() || this.variableIds == null || this.variableIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with \"activityId\" and a non-empty \"variableIds\" array.");
        }
        Process process = toolContext.getProcess();
        Optional<Activity> activityOpt = process.getActivities().stream().filter(act -> act.getId().equals(this.activityId)).findFirst();
        if (activityOpt.isEmpty()) {
            return new ToolResult(false, "Error: Activity with activityId: '" + this.activityId + "' doesn't exist!.");
        }
        Activity activity = activityOpt.get();
        ArrayList<DeleteResult> results = new ArrayList<DeleteResult>();
        for (String variableId : this.variableIds) {
            int variableAssignmentIndex = -1;
            for (int i = 0; i < activity.getVariableRefs().size(); ++i) {
                if (!activity.getVariableRefs().get(i).getId().equals(variableId)) continue;
                variableAssignmentIndex = i;
                break;
            }
            if (variableAssignmentIndex == -1) {
                results.add(new DeleteResult(this.activityId, variableId, "failed", "Error: Variable with variableId: '" + variableId + "' is not assigned to activity with activityId: '" + this.activityId + "'."));
                continue;
            }
            activity.getVariableRefs().remove(variableAssignmentIndex);
            results.add(new DeleteResult(this.activityId, variableId, "success", "Successfully deleted assignment of variable with variableId: '" + variableId + "' from activity with activityId: '" + this.activityId + "'."));
        }
        String formattedData = results.stream().map(r -> "activityId: " + r.activityId() + ", variableId: " + r.variableId() + ", status: " + r.status() + ", message: " + r.message()).reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
        boolean isSuccess = results.stream().anyMatch(r -> "success".equals(r.status()));
        return new ToolResult(isSuccess, "Deletion results:\n" + formattedData);
    }

    public String getActivityId() {
        return this.activityId;
    }

    public List<String> getVariableIds() {
        return this.variableIds;
    }

    private record DeleteResult(String activityId, String variableId, String status, String message) {
    }
}

