/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "delete_activity", "Deletes one or more activities from the process map. Returns the deleted activity IDs in the following format: { \"deletedActivityIds\": [\"<id1>\", \"<id2>\"] }", "To delete activities write { \"activityIds\": [\"<id1>\", \"<id2>\"] }.", DeleteActivityTool.class);
    private final List<String> activityIds;

    @JsonCreator
    public DeleteActivityTool(@JsonProperty(value="activityIds") List<String> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityIds == null || this.activityIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"activityIds\" array of strings.");
        }
        Process process = toolContext.getProcess();
        ArrayList<String> deletedIds = new ArrayList<String>();
        ArrayList<String> notFoundIds = new ArrayList<String>();
        HashSet<String> idsToDelete = new HashSet<String>(this.activityIds);
        HashSet currentActivityIds = new HashSet();
        process.getActivities().forEach(a -> currentActivityIds.add(a.getId()));
        for (String id : idsToDelete) {
            if (currentActivityIds.contains(id)) {
                deletedIds.add(id);
                continue;
            }
            notFoundIds.add(id);
        }
        if (deletedIds.size() > 0) {
            process.getActivities().removeIf(activity -> idsToDelete.contains(activity.getId()));
            process.getTransitions().removeIf(transition -> idsToDelete.contains(transition.getSourceId()) || idsToDelete.contains(transition.getTargetId()));
        }
        Object data = "";
        if (deletedIds.size() > 0) {
            data = (String)data + "Successfully deleted activities with activityId's: " + String.join((CharSequence)", ", deletedIds) + ".";
        }
        if (notFoundIds.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n";
            }
            data = (String)data + "Activities with the following activityId's were not found: " + String.join((CharSequence)", ", notFoundIds) + ".";
        }
        if (deletedIds.isEmpty() && !notFoundIds.isEmpty()) {
            return new ToolResult(false, "No activities deleted. Activities with the following activityId's were not found: " + String.join((CharSequence)", ", notFoundIds) + ".");
        }
        return new ToolResult(true, (String)data);
    }

    public List<String> getActivityIds() {
        return this.activityIds;
    }
}

