/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckVariablesExistByVariableNameTool
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(CheckVariablesExistByVariableNameTool.class);
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "check_variables_exist_by_variableName", "Use this tool to search for process map variable(s).\nTool finds variables by providing a list of their names using fuzzy search.\nVariables are used for storing data. Variable is a component that represents a field on a activity form in which values a specific type can be placed.\n(VARIABLES DO NOT STORE ACCEPTANCE BUTTONS).\nReturns the variables found by variableName in the following format: { \"variableId\": \"<id>\", \"variableName\": \"<name>\", \"variableType\": \"<type>\" }.\nVariables are used for storing data on a form.\n", "To find variables write { \"variableNames\": [\"<name of variable 1>\", \"name of variable 2\"] }.", CheckVariablesExistByVariableNameTool.class);
    private final List<String> variableNames;

    @JsonCreator
    public CheckVariablesExistByVariableNameTool(@JsonProperty(value="variableNames") List<String> variableNames) {
        this.variableNames = variableNames;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.variableNames == null || this.variableNames.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"variableNames\" array of strings.");
        }
        try {
            Process process = toolContext.getProcess();
            ByteBuffersDirectory dir = new ByteBuffersDirectory();
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            IndexWriter writer = new IndexWriter((Directory)dir, config);
            for (Variable variable : process.getVariables()) {
                this.addDoc(writer, variable.getId(), variable.getName());
            }
            writer.close();
            DirectoryReader reader = DirectoryReader.open((Directory)dir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ArrayList<FoundVariable> foundVariables = new ArrayList<FoundVariable>();
            HashSet<String> foundVariableIds = new HashSet<String>();
            ArrayList<String> notFoundNames = new ArrayList<String>();
            for (String name : this.variableNames) {
                Term term = new Term("variableName", name);
                FuzzyQuery query = new FuzzyQuery(term, 2);
                TopDocs hits = searcher.search((Query)query, 10);
                if (hits.scoreDocs.length > 0) {
                    Document d = searcher.storedFields().document(hits.scoreDocs[0].doc);
                    String variableId = d.get("variableId");
                    Optional<Variable> variableOpt = process.getVariables().stream().filter(var -> var.getId().equals(variableId)).findFirst();
                    if (!variableOpt.isPresent() || foundVariableIds.contains(variableId)) continue;
                    Variable variable = variableOpt.get();
                    foundVariables.add(new FoundVariable(variable.getId(), variable.getName(), variable.getType().name()));
                    foundVariableIds.add(variableId);
                    continue;
                }
                notFoundNames.add(name);
            }
            reader.close();
            dir.close();
            Object data = "";
            if (foundVariables.size() > 0) {
                String formattedFound = foundVariables.stream().map(v -> "variableId: " + v.variableId() + ", variableName: '" + v.variableName() + "', variableType: " + v.variableType()).reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
                data = (String)data + "Found variables:\n" + formattedFound;
            }
            if (notFoundNames.size() > 0) {
                if (!((String)data).isEmpty()) {
                    data = (String)data + "\n";
                }
                data = (String)data + "Variables not found for names: " + String.join((CharSequence)", ", notFoundNames) + ". Probably they doesn't exsist in the process map.";
            }
            if (foundVariables.isEmpty()) {
                return new ToolResult(true, "No variables found for the given names: " + String.join((CharSequence)", ", notFoundNames) + ". Probably they doesn't exsist in the process map.");
            }
            return new ToolResult(true, (String)data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ToolResult(false, "Error: " + e.getMessage());
        }
    }

    private void addDoc(IndexWriter w, String variableId, String variableName) throws Exception {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("variableId", variableId, Field.Store.YES));
        doc.add((IndexableField)new TextField("variableName", variableName, Field.Store.YES));
        w.addDocument((Iterable)doc);
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    private record FoundVariable(String variableId, String variableName, String variableType) {
    }
}

