/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckActivitiesExistByActivityNameTool
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(CheckActivitiesExistByActivityNameTool.class);
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "check_activities_exist_by_activityName", "Search for activity(ies) details and finds activities by providing a list of their names using fuzzy search. Returns the activities found by activityName in the following format: { \"activityId\": \"<id>\", \"activityName\": \"<name>\" }", "To find activities write { \"activityNames\": [\"<name of activity 1>\", \"name of activity 2\"] }.", CheckActivitiesExistByActivityNameTool.class);
    private final List<String> activityNames;

    @JsonCreator
    public CheckActivitiesExistByActivityNameTool(@JsonProperty(value="activityNames") List<String> activityNames) {
        this.activityNames = activityNames;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityNames == null || this.activityNames.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"activityNames\" array of strings.");
        }
        try {
            Process process = toolContext.getProcess();
            ByteBuffersDirectory dir = new ByteBuffersDirectory();
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            IndexWriter writer = new IndexWriter((Directory)dir, config);
            for (Activity activity : process.getActivities()) {
                this.addDoc(writer, activity.getId(), activity.getName());
            }
            writer.close();
            DirectoryReader reader = DirectoryReader.open((Directory)dir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ArrayList<FoundActivity> foundActivities = new ArrayList<FoundActivity>();
            HashSet<String> foundActivityIds = new HashSet<String>();
            ArrayList<String> notFoundNames = new ArrayList<String>();
            for (String name : this.activityNames) {
                Term term = new Term("activityName", name);
                FuzzyQuery query = new FuzzyQuery(term, 2);
                TopDocs hits = searcher.search((Query)query, 10);
                if (hits.scoreDocs.length > 0) {
                    Document d = searcher.storedFields().document(hits.scoreDocs[0].doc);
                    String activityId = d.get("activityId");
                    String activityName = d.get("activityName");
                    if (foundActivityIds.contains(activityId)) continue;
                    foundActivities.add(new FoundActivity(activityId, activityName));
                    foundActivityIds.add(activityId);
                    continue;
                }
                notFoundNames.add(name);
            }
            reader.close();
            dir.close();
            Object data = "";
            if (foundActivities.size() > 0) {
                String formattedFound = foundActivities.stream().map(a -> "activityId: " + a.activityId() + ", activityName: '" + a.activityName() + "'").reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
                data = (String)data + "Found activities:\n" + formattedFound;
            }
            if (notFoundNames.size() > 0) {
                if (!((String)data).isEmpty()) {
                    data = (String)data + "\n";
                }
                data = (String)data + "Activities not found for names: " + String.join((CharSequence)", ", notFoundNames) + ". Probably they doesn't exsist in the process map.";
            }
            if (foundActivities.isEmpty()) {
                return new ToolResult(true, "No activities found for the given names: " + String.join((CharSequence)", ", notFoundNames) + ". Probably they doesn't exsist in the process map.");
            }
            return new ToolResult(true, (String)data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ToolResult(false, "Error: " + e.getMessage());
        }
    }

    private void addDoc(IndexWriter w, String activityId, String activityName) throws Exception {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("activityId", activityId, Field.Store.YES));
        doc.add((IndexableField)new TextField("activityName", activityName, Field.Store.YES));
        w.addDocument((Iterable)doc);
    }

    public List<String> getActivityNames() {
        return this.activityNames;
    }

    public record FoundActivity(String activityId, String activityName) {
    }
}

