/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRefType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AssignVariableToActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "assign_variable_to_activity", "Assigns one or more variables to one or more activities with a specific visibility type. Returns a list of assignment results in the following format: { \"assignments\": [ { \"activityId\": \"<id>\", \"variableId\": \"<id>\", \"visibilityType\": \"<type>\", \"status\": \"success|failed\", \"message\": \"<message>\" } ] }", "To assign variables to activities, write { \"assignments\": [{ \"activityId\": \"<id>\", \"variables\": [{ \"variableId\": \"<id>\", \"visibilityType\": \"<type>\" }] }] }. Allowed visibility types are 'UPDATE', 'VIEW', 'HIDDEN'.\nVisibility types description:\n- UPDATE: makes variable editable and visible\n- VIEW: makes variable not editable and visible\n- HIDDEN: makes variable editable and not visible\nDEFAULT VISIBILITY TYPE IS 'UPDATE'", AssignVariableToActivityTool.class);
    private final List<ToActivity> assignments;

    @JsonCreator
    public AssignVariableToActivityTool(@JsonProperty(value="assignments") List<ToActivity> assignments) {
        this.assignments = assignments;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.assignments == null || this.assignments.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting an object with a non-empty \"assignments\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<AssignmentResult> results = new ArrayList<AssignmentResult>();
        for (ToActivity assignment : this.assignments) {
            String activityId = assignment.getActivityId();
            List<VariableRef> variableRefs = assignment.getVariables();
            if (activityId == null || activityId.isBlank() || variableRefs == null || variableRefs.isEmpty()) continue;
            Optional<Activity> activityOpt = process.getActivities().stream().filter(act -> act.getId().equals(activityId)).findFirst();
            if (activityOpt.isEmpty()) {
                for (VariableRef variableData : variableRefs) {
                    results.add(new AssignmentResult(activityId, variableData.getVariableId(), variableData.getVisibilityType() != null ? variableData.getVisibilityType().name() : "UPDATE", "failed", "Error: Activity with activityId: '" + activityId + "' doesn't exist!."));
                }
                continue;
            }
            Activity activity = activityOpt.get();
            for (VariableRef variableData : variableRefs) {
                String variableId = variableData.getVariableId();
                VariableRefType visibilityType = variableData.getVisibilityType() != null ? variableData.getVisibilityType() : VariableRefType.UPDATE;
                Optional<Variable> variableOpt = process.getVariables().stream().filter(v -> v.getId().equals(variableId)).findFirst();
                if (variableOpt.isEmpty()) {
                    results.add(new AssignmentResult(activityId, variableId, visibilityType.name(), "failed", "Error: Variable with variableId: '" + variableId + "' doesn't exist!."));
                    continue;
                }
                boolean alreadyAssigned = activity.getVariableRefs().stream().anyMatch(vr -> vr.getId().equals(variableId));
                if (alreadyAssigned) {
                    results.add(new AssignmentResult(activityId, variableId, visibilityType.name(), "failed", "Error: Variable with variableId: '" + variableId + "' is already assigned to activity with activityId: '" + activityId + "'."));
                    continue;
                }
                com.suncode.pwfl.workflow.process.map.VariableRef variableRef = new com.suncode.pwfl.workflow.process.map.VariableRef(variableId, visibilityType, activity.getVariableRefs().size());
                activity.getVariableRefs().add(variableRef);
                results.add(new AssignmentResult(activityId, variableId, visibilityType.name(), "success", "Successfully assigned variable with variableId: '" + variableId + "' to activity with activityId: '" + activity.getId() + "' with visibilityType: '" + String.valueOf((Object)visibilityType) + "'."));
            }
        }
        String formattedData = results.stream().map(r -> "activityId: " + r.activityId() + ", variableId: " + r.variableId() + ", status: " + r.status() + ", message: " + r.message()).reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
        boolean isSuccess = results.stream().anyMatch(r -> "success".equals(r.status()));
        return new ToolResult(isSuccess, "Assignment results:\n" + formattedData);
    }

    public List<ToActivity> getAssignments() {
        return this.assignments;
    }

    public static class ToActivity {
        @JsonProperty(required=true)
        private String activityId;
        @JsonProperty(required=true)
        private List<VariableRef> variables;

        public String getActivityId() {
            return this.activityId;
        }

        public List<VariableRef> getVariables() {
            return this.variables;
        }

        @JsonProperty(required=true)
        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        @JsonProperty(required=true)
        public void setVariables(List<VariableRef> variables) {
            this.variables = variables;
        }

        public ToActivity(String activityId, List<VariableRef> variables) {
            this.activityId = activityId;
            this.variables = variables;
        }

        public ToActivity() {
        }
    }

    public static class VariableRef {
        @JsonProperty(required=true)
        private String variableId;
        @JsonProperty
        private VariableRefType visibilityType;

        public String getVariableId() {
            return this.variableId;
        }

        public VariableRefType getVisibilityType() {
            return this.visibilityType;
        }

        @JsonProperty(required=true)
        public void setVariableId(String variableId) {
            this.variableId = variableId;
        }

        @JsonProperty
        public void setVisibilityType(VariableRefType visibilityType) {
            this.visibilityType = visibilityType;
        }

        public VariableRef(String variableId, VariableRefType visibilityType) {
            this.variableId = variableId;
            this.visibilityType = visibilityType;
        }

        public VariableRef() {
        }
    }

    private record AssignmentResult(String activityId, String variableId, String visibilityType, String status, String message) {
    }
}

