/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableAgentAnswerPromptProvider;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.prompting.LlmService;
import com.suncode.pwfl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnswerToAgentTool
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(AnswerToAgentTool.class);
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.VARIABLE, "answer_to_agent", "Use this tool to answer the main agent or communicate to main agent for missing informations.", "To answer the user write { \"answer\": \"<answer>\" }", AnswerToAgentTool.class);
    private final String answer;

    @JsonCreator
    public AnswerToAgentTool(@JsonProperty(value="answer") String answer) {
        this.answer = answer;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (StringUtils.isBlank(this.answer)) {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"answer\" string.");
        }
        LlmService llmService = toolContext.getLlmService();
        String userMessage = toolContext.getUserMessage();
        try {
            VariableAgentAnswerPromptProvider answerPromptProvider = new VariableAgentAnswerPromptProvider();
            String processMapAnalysisRaw = llmService.chat(answerPromptProvider.provide(toolContext.getState()), userMessage);
            if (StringUtils.isBlank(processMapAnalysisRaw)) {
                return new ToolResult(false, "Error: Failed to generate response from LLM.");
            }
            return new ToolResult(true, processMapAnalysisRaw);
        }
        catch (Exception e) {
            log.error("Error executing answer_to_agent tool", (Throwable)e);
            return new ToolResult(false, "Error: " + e.getMessage());
        }
    }

    public String getAnswer() {
        return this.answer;
    }
}

