/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.prompts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.config.AIAssistantObjectMapper;
import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import java.util.List;
import java.util.stream.Collectors;

public class VariableAgentAnswerPromptProvider
implements PromptProvider {
    @Override
    public String provide(AgentState state) {
        AIAssistantObjectMapper objectMapper = new AIAssistantObjectMapper();
        String prompt = "- Inform the agent about the tasks you've performed. Be concise but informative.\n- Use the same language as the agent's message to answer.\n- Don't ask about further actions.\n- Never tell the agent what tool names you used, if you used a tool that does not exist, just ignore this fact and inform the agent that you can't answer to this question/can't perform this task.\n- Omit information about what was verified to achieve the goal (check/get methods) from the response. In the response, we're interested in the result and to fullify agent's request, not the individual steps.\n- If the agent asked for information about some components - provide full information about them (including their ids like activityId, variableId, variableType) about them.\n\n<performed_tasks>\n%s\n</performed_tasks>\n";
        String performedTasks = state.getTasks().stream().map(task -> this.buildTaskTag((Task)task, objectMapper)).collect(Collectors.joining("\n"));
        return String.format(prompt, performedTasks);
    }

    private String buildTaskTag(Task task, ObjectMapper objectMapper) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<task name=\"%s\" status=\"%s\">", task.getName(), task.getState().name()));
        stringBuilder.append(String.format("  <description>%s</description>", task.getDescription()));
        stringBuilder.append("  <actions>");
        stringBuilder.append(this.buildActionsTagContent(task.getActions(), objectMapper));
        stringBuilder.append("  </actions>");
        return stringBuilder.toString();
    }

    private String buildActionsTagContent(List<Action> actions, ObjectMapper objectMapper) {
        return actions.stream().map(action -> String.format("  %s", this.buildActionTag((Action)action, objectMapper))).collect(Collectors.joining("\n"));
    }

    private String buildActionTag(Action action, ObjectMapper objectMapper) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<action tool=\"%s\" status=\"%s\">", action.getToolName(), action.getState().name()));
        if (action.getResult() != null) {
            stringBuilder.append(String.format("  <result>%s</result>", action.getResult().getData() instanceof String ? action.getResult().getData() : objectMapper.writeValueAsString(action.getResult().getData())));
        }
        stringBuilder.append("<action>");
        return stringBuilder.toString();
    }
}

