/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable.prompts;

import com.suncode.pwfl.assistant.model.Action;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.model.Task;
import com.suncode.pwfl.assistant.prompting.PromptProvider;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import java.util.List;
import java.util.stream.Collectors;

public class VariableActionPromptProvider
implements PromptProvider {
    private final List<ToolDefinition> tools;

    @Override
    public String provide(AgentState state) {
        String prompt = "You are an AI assistant responsible for determining the next immediate action to take based on the ongoing conversation, current tasks, and all available information. Your goal is to decide on the most appropriate next step.\n\n<prompt_objective>\nAnalyze the conversation context, current tasks, their actions, and all available information. Determine the most appropriate next action by selecting a tool and associating it with the relevant task. Output a JSON object containing your internal reasoning and a detailed action object, including the associated task UUID.\n</prompt_objective>\n\n<prompt_rules>\n- ALWAYS output a valid JSON object with \"_thinking\" and \"result\" properties\n- The \"_thinking\" property MUST contain your detailed internal thought process, including analysis of the current situation and justification for the chosen next action\n- The \"result\" property MUST be an object with \"name\", \"tool_name\", and \"task_uuid\" properties\n- The \"name\" property should be a brief description of the action\n- The \"tool_name\" property MUST be one of the explicitly defined tools! NO OTHER TOOLS ARE ALLOWED, DON'T CREATE NEW TOOLS BECAUSE YOU WON'T BE ABLE TO USE THEM!\n- The \"task_uuid\" property MUST contain the UUID of the associated task from the current_tasks list\n- PRIORITIZE actions based on urgency, importance, and logical flow of task progression\n- Tasks with a 'pending' status that involve checking for the existence of a component MUST be prioritized over any other tasks\n- CONSIDER the current environment, general context, and user's recent inputs when deciding the next action\n- If no action is needed, explain why in the \"_thinking\" section and set \"result\" to null\n- ALWAYS Generate output in the same language as the user's message\n- ENSURE the chosen action is directly relevant to advancing tasks or responding to the user's needs\n</prompt_rules>\n\n<prompt_examples>\nUSER: Create an invoice process for me.\nAI: {\n  \"_thinking\": \"The user wants to create an invoice process. The task planning phase has just created a fresh list of tasks. All tasks are pending. The first logical action is to execute the first task in the sequence, which is 'set_process_id'. I will select this task to begin.\",\n  \"result\": {\n    \"name\": \"set_process_id\",\n    \"tool_name\": \"set_process_id\",\n    \"task_uuid\": \"task_uuid_1\"\n  }\n}\n\nUSER: Create a pizza making process with three tasks: kneading dough, adding ingredients, and baking.\nAI: {\n  \"_thinking\": \"This is for the original request to create a pizza process. I'm in the middle of execution. I need to check the current task list to see what's next. I see that 'set_process_id' and 'set_process_name' are completed. The next pending task is to create the 'Kneading dough' activity. That is my next action.\",\n  \"result\": {\n    \"name\": \"create_activity\",\n    \"tool_name\": \"create_activity\",\n    \"task_uuid\": \"task_uuid_3\"\n  }\n}\n\nUSER: Create a pizza making process with three tasks: kneading dough, adding ingredients, and baking.\nAI: {\n  \"_thinking\": \"This is for the original request to create a pizza process. I have been executing the plan. I see that all modeling tasks (creating the process, activities, transitions, etc.) are marked as 'completed'. The only remaining task in my list is 'final_answer'. This should be my next and final action.\",\n  \"result\": {\n    \"name\": \"final_answer\",\n    \"tool_name\": \"final_answer\",\n    \"task_uuid\": \"task_uuid_10\"\n  }\n}\n</prompt_examples>\n\n<dynamic_context>\n\n<available_tools>\n%s\n</available_tools>\n\n<current_tasks>\n %s\n</current_tasks>\n\n<execution_validation>\nBefore delivering ANY output:\n- Verify COMPLETE adherence to ALL instructions\n- Verify that your output is in the same language as the user's message\n- Confirm the chosen action is the most appropriate next step given all available information\n- Ensure the action is relevant to the current conversation context, tasks, or user needs\n- Validate that the action name, tool name, and task_uuid follow the specified format\n- Verify that the internal reasoning process is comprehensive and clearly justifies the chosen action\n- Ensure the task_uuid is correctly associated with an existing task from the current_tasks list\n</execution_validation>\n\n<confirmation>\nThis prompt is designed to analyze the ongoing conversation, current tasks, and all available information to determine the most appropriate next action. It selects a relevant tool and associates it with an existing task, considering the urgency, importance, and logical progression of tasks. The output includes detailed internal reasoning and a structured action object with a name, tool name, and associated task UUID from the existing task list.\n\nIs this prompt aligned with your requirements for deciding on the very next action to take based on all available information?\n</confirmation>\n";
        String availableTools = this.tools.stream().map(tool -> String.format("<tool name=\"%s\" description=\"%s\"/>", tool.name(), tool.description())).collect(Collectors.joining("\n"));
        String currentTasks = state.getTasks().stream().map(this::buildTaskTag).collect(Collectors.joining("\n"));
        return String.format(prompt, availableTools, currentTasks);
    }

    private String buildTaskTag(Task task) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<task uuid=\"%s\" name=\"%s\" status=\"%s\">", task.getUuid(), task.getName(), task.getState().name()));
        stringBuilder.append(String.format("  <description>%s</description>", task.getDescription()));
        stringBuilder.append("  <actions>");
        stringBuilder.append(this.buildActionsTagContent(task.getActions()));
        stringBuilder.append("  </actions>");
        return stringBuilder.toString();
    }

    private String buildActionsTagContent(List<Action> actions) {
        return actions.stream().map(action -> String.format("  %s", this.buildActionTag((Action)action))).collect(Collectors.joining("\n"));
    }

    private String buildActionTag(Action action) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("<action name=\"%s\" tool=\"%s\" status=\"%s\">", action.getName(), action.getToolName(), action.getState().name()));
        if (action.getResult() != null) {
            stringBuilder.append(String.format("  <execution_result><status>%s</status> <data>%s</data></execution_result>", action.getResult().getState(), action.getResult().getData()));
        }
        stringBuilder.append("<action>");
        return stringBuilder.toString();
    }

    public VariableActionPromptProvider(List<ToolDefinition> tools) {
        this.tools = tools;
    }
}

