/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.variable;

import com.suncode.pwfl.assistant.AgentContext;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.agent.Agent;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableActionPromptProvider;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableActionUsePromptProvider;
import com.suncode.pwfl.assistant.agent.variable.prompts.VariableTaskPromptProvider;
import com.suncode.pwfl.assistant.model.AgentState;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableAgent
implements Agent {
    private static final Logger log = LoggerFactory.getLogger(VariableAgent.class);
    private final AgentState agentState;
    private final VariableActionPromptProvider actionPromptProvider;
    private final VariableActionUsePromptProvider actionUsePromptProvider;
    private final VariableTaskPromptProvider taskPromptProvider;

    public VariableAgent(AgentContext agentContext, Process process) {
        this.agentState = new AgentState(process);
        List<ToolDefinition> tools = agentContext.getToolRegistry().getToolDefinitionsForAgentType(AgentType.VARIABLE);
        this.actionPromptProvider = new VariableActionPromptProvider(tools);
        this.actionUsePromptProvider = new VariableActionUsePromptProvider(tools);
        this.taskPromptProvider = new VariableTaskPromptProvider(tools);
        log.debug("Created {}", (Object)this);
    }

    @Override
    public AgentType getAgentType() {
        return AgentType.VARIABLE;
    }

    @Override
    public AgentState getState() {
        return this.agentState;
    }

    @Override
    public String getActionPrompt() {
        return this.actionPromptProvider.provide(this.agentState);
    }

    @Override
    public String getActionUsePrompt() {
        return this.actionUsePromptProvider.provide(this.agentState);
    }

    @Override
    public String getTaskPrompt() {
        return this.taskPromptProvider.provide(this.agentState);
    }

    public String toString() {
        return "Variable agent";
    }
}

