/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.AcceptButton;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class UpdateAcceptButtonsOnActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "update_accept_buttons_on_activity", "Updates one or more existing accept buttons on a specified activity.\nA new buttonId is generated for each button based on its new name.\n", "To update accept buttons, write { \"activityId\": \"<id>\", \"updates\": [ { \"acceptButtonId\": \"<id to update>\", \"newAcceptButtonName\": \"<new name>\" } ] }", UpdateAcceptButtonsOnActivityTool.class);
    private final String activityId;
    private final List<ButtonUpdate> updates;

    @JsonCreator
    public UpdateAcceptButtonsOnActivityTool(@JsonProperty(value="activityId") String activityId, @JsonProperty(value="updates") List<ButtonUpdate> updates) {
        this.activityId = activityId;
        this.updates = updates;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityId == null || this.activityId.isBlank() || this.updates == null || this.updates.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"activityId\" and a non-empty \"updates\" array.");
        }
        Process process = toolContext.getProcess();
        Activity activity = process.getActivities().stream().filter(act -> act.getId().equals(this.activityId)).findFirst().orElse(null);
        if (activity == null) {
            return new ToolResult(false, "Error: Activity with activityId: '" + this.activityId + "' doesn't exist!.");
        }
        ArrayList<ButtonUpdateOutput> updatedButtons = new ArrayList<ButtonUpdateOutput>();
        ArrayList<Object> errors = new ArrayList<Object>();
        for (ButtonUpdate update : this.updates) {
            String acceptButtonId = update.getAcceptButtonId();
            String newAcceptButtonName = update.getNewAcceptButtonName();
            if (acceptButtonId == null || acceptButtonId.isBlank() || newAcceptButtonName == null || newAcceptButtonName.isBlank()) {
                errors.add("Error: Invalid update object. Expecting \"acceptButtonId\" and \"newAcceptButtonName\".");
                continue;
            }
            Optional<AcceptButton> acceptButtonOptional = activity.getAcceptButtons().stream().filter(button -> button.getId().equals(acceptButtonId)).findFirst();
            if (acceptButtonOptional.isEmpty()) {
                errors.add("Error: Accept button with acceptButtonId: '" + acceptButtonId + "' not found on activity with activityId: '" + this.activityId + "'.");
                continue;
            }
            AcceptButton acceptButton = acceptButtonOptional.get();
            String oldAcceptButtonId = acceptButton.getId();
            String newAcceptButtonId = this.generateUniqueAcceptButtonId(activity, newAcceptButtonName, oldAcceptButtonId);
            acceptButton.setId(newAcceptButtonId);
            acceptButton.setName(newAcceptButtonName);
            updatedButtons.add(new ButtonUpdateOutput(this.activityId, oldAcceptButtonId, newAcceptButtonId, newAcceptButtonName));
        }
        Object data = "";
        if (updatedButtons.size() > 0) {
            String formattedUpdated = updatedButtons.stream().map(u -> "Old acceptButtonId: '" + u.oldAcceptButtonId() + "', New acceptButtonName: '" + u.newAcceptButtonName() + "', New acceptButtonId: '" + u.newAcceptButtonId() + "'.").reduce("", (acc, item) -> acc.isEmpty() ? item : acc + "\n" + item);
            data = (String)data + "Successfully updated " + updatedButtons.size() + " buttons on activity '" + this.activityId + "':\n" + formattedUpdated;
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Errors:\n" + String.join((CharSequence)"\n", errors);
        }
        if (updatedButtons.isEmpty() && errors.size() > 0) {
            return new ToolResult(false, (String)data);
        }
        return new ToolResult(true, (String)(((String)data).isEmpty() ? "No buttons were updated." : data));
    }

    private String generateUniqueAcceptButtonId(Activity activity, String buttonName, String currentButtonId) {
        String baseAcceptButtonId = Normalizer.normalize(buttonName, Normalizer.Form.NFD).toLowerCase().replaceAll("[\\u0300-\\u036f]", "").replaceAll("\\s+", "_").replaceAll("[^a-z0-9_]", "");
        if (baseAcceptButtonId.length() > 16) {
            baseAcceptButtonId = baseAcceptButtonId.substring(0, 16);
        }
        String baseId = baseAcceptButtonId;
        Object newAcceptButtonId = baseId;
        int counter = 1;
        while (true) {
            String currentId = newAcceptButtonId;
            boolean exists = activity.getAcceptButtons().stream().anyMatch(b -> b.getId().equals(currentId) && !b.getId().equals(currentButtonId));
            if (!exists) break;
            String counterStr = String.valueOf(counter);
            int maxLength = 16 - counterStr.length();
            String trimmedId = baseId.length() > maxLength ? baseId.substring(0, maxLength) : baseId;
            newAcceptButtonId = trimmedId + counter;
            ++counter;
        }
        return newAcceptButtonId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public List<ButtonUpdate> getUpdates() {
        return this.updates;
    }

    public static class ButtonUpdate {
        @JsonProperty(required=true)
        private String acceptButtonId;
        @JsonProperty(required=true)
        private String newAcceptButtonName;

        public String getAcceptButtonId() {
            return this.acceptButtonId;
        }

        public String getNewAcceptButtonName() {
            return this.newAcceptButtonName;
        }

        @JsonProperty(required=true)
        public void setAcceptButtonId(String acceptButtonId) {
            this.acceptButtonId = acceptButtonId;
        }

        @JsonProperty(required=true)
        public void setNewAcceptButtonName(String newAcceptButtonName) {
            this.newAcceptButtonName = newAcceptButtonName;
        }

        public ButtonUpdate(String acceptButtonId, String newAcceptButtonName) {
            this.acceptButtonId = acceptButtonId;
            this.newAcceptButtonName = newAcceptButtonName;
        }

        public ButtonUpdate() {
        }
    }

    public record ButtonUpdateOutput(String activityId, String oldAcceptButtonId, String newAcceptButtonId, String newAcceptButtonName) {
    }
}

