/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.query.ProcessMapDataQuery;
import com.suncode.pwfl.workflow.process.map.transition.Gateway;
import com.suncode.pwfl.workflow.process.map.transition.GatewayType;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import com.suncode.pwfl.workflow.process.map.transition.condition.Condition;
import com.suncode.pwfl.workflow.process.map.validator.ConditionValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class SetGatewayAsOutgoingTransitionFromSourceActivityIdTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "set_gateway_as_outgoing_transition_from_source_activityId", "Sets a gateway as the outgoing transition from a source activity. If an outgoing transition already exists for the source activity (either direct or to another gateway), it will be overwritten. The gateway defines logic for forking the process flow.\n- 'gatewayType': Can be 'XOR' for an exclusive choice (first condition that is true is taken and process flows to the defined targetActivityId - order of conditions is important then) or 'AND' for a parallel split (multiple paths can be taken simultaneously).\n- 'transitions': An array of objects, where each object defines a path from the gateway to a 'targetActivityId'.\nEach transition is governed by a 'condition' object.\n- For 'XOR' gateways, every transition MUST have a condition! (condition created using acceptButtonId or variableId or both).\n- For 'AND' gateways, the 'condition' for each transition is optional. A transition can be unconditional, or it can have a simple or complex nested condition just like in an 'XOR' gateway. All paths whose conditions are met (including all unconditional paths) will be activated in parallel creating instances of activities for which the conditions have been met.\nThe 'condition' object can be a simple 'SimpleCondition' or a complex 'GroupCondition'.\nEach 'condition' object MUST contain 'type' property determining condition type.\n- 'SimpleCondition': A single logical check. It can contain:\n    - 'acceptButtonId': The acceptButtonId of an existing button on the source activity. The condition is met if this button was used to complete the task.\n    - 'variableId', 'operator', 'value': A comparison of a process variable (e.g., amount > 1000).\n    - Both 'acceptButtonId' and a variable check can be combined in one atomic condition.\n    - 'type' property MUST be set to 'simple'\n- 'GroupCondition': For complex logic, it contains:\n    - 'operator': 'AND' or 'OR'.\n    - 'conditions': An array of 'SimpleCondition' and/or other 'GroupCondition' objects, allowing for deep nesting.\n    - 'type' property MUST be set to 'group'\n", "To create a gateway, write { \"sourceActivityId\": \"<id>\", \"gatewayType\": \"XOR|AND\", \"transitions\": [ { \"targetActivityId\": \"<id>\", \"condition\": { ... } } ] }. The 'condition' can be a simple check or a nested structure. Example of a complex condition: { \"type\": \"group\", \"operator\": \"OR\", \"conditions\": [ { \"type\": \"group\", \"operator\": \"AND\", \"conditions\": [ { \"type\": \"simple\", \"acceptButtonId\": \"accept\" }, { \"type\": \"simple\", \"variableId\": \"amount\", \"operator\": \">\", \"value\": 1000 } ] }, { \"type\": \"simple\", \"variableId\": \"status\", \"operator\": \"==\", \"value\": \"approved\" } ] }. For 'AND' transitions, provide `{ \"type\": \"group\", \"operator\": \"AND\", \"conditions\": [] }` for unconditional paths. Supported operators: '==', '!=', '<=', '>=', '<', '>'", SetGatewayAsOutgoingTransitionFromSourceActivityIdTool.class);
    private final String sourceActivityId;
    private final GatewayType gatewayType;
    private final List<TransitionToAdd> transitions;

    @JsonCreator
    public SetGatewayAsOutgoingTransitionFromSourceActivityIdTool(@JsonProperty(value="sourceActivityId") String sourceActivityId, @JsonProperty(value="gatewayType") GatewayType gatewayType, @JsonProperty(value="transitions") List<TransitionToAdd> transitions) {
        this.sourceActivityId = sourceActivityId;
        this.gatewayType = gatewayType;
        this.transitions = transitions;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.sourceActivityId == null || this.sourceActivityId.isBlank() || this.gatewayType == null || this.transitions == null || this.transitions.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"sourceActivityId\", \"gatewayType\", and a non-empty \"transitions\" array.");
        }
        Process process = toolContext.getProcess();
        ProcessMapDataQuery processMapDataQuery = new ProcessMapDataQuery(process);
        Optional<Activity> sourceActivityOpt = processMapDataQuery.getActivity(this.sourceActivityId);
        if (sourceActivityOpt.isEmpty()) {
            return new ToolResult(false, "Error: Source activity with activityId: '" + this.sourceActivityId + "' doesn't exist!.");
        }
        Activity sourceActivity = sourceActivityOpt.get();
        ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList<Transition> validatedTransitions = new ArrayList<Transition>();
        for (TransitionToAdd transitionToAdd : this.transitions) {
            String targetActivityId = transitionToAdd.getTargetActivityId();
            Optional<Activity> targetActivityOpt = processMapDataQuery.getActivity(targetActivityId);
            if (targetActivityOpt.isEmpty()) {
                errors.add("Target activity with activityId: '" + targetActivityId + "' not found.");
                continue;
            }
            Condition condition = transitionToAdd.getCondition();
            if (this.gatewayType == GatewayType.XOR && condition == null) {
                errors.add("For XOR gateway, a condition is required for transition to '" + targetActivityId + "'. The transition should be linked to at least a dedicated button if there is no need to define conditions on process variables.");
                continue;
            }
            if (condition != null) {
                try {
                    ConditionValidator.validateCondition(condition, process, sourceActivity);
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                    continue;
                }
            }
            Transition transition2 = new Transition(UUID.randomUUID().toString(), "", targetActivityId, condition);
            validatedTransitions.add(transition2);
        }
        if (!errors.isEmpty()) {
            return new ToolResult(false, "Errors found:\n" + String.join((CharSequence)"\n", errors));
        }
        process.getTransitions().removeIf(transition -> transition.getSourceId().equals(this.sourceActivityId));
        Gateway gateway = new Gateway(UUID.randomUUID().toString(), this.gatewayType);
        process.getGateways().add(gateway);
        Transition gatewayTransition = new Transition(UUID.randomUUID().toString(), this.sourceActivityId, gateway.getId());
        process.getTransitions().add(gatewayTransition);
        for (Transition transition3 : validatedTransitions) {
            transition3.setSourceId(gateway.getId());
            process.getTransitions().add(transition3);
        }
        return new ToolResult(true, "Successfully set " + String.valueOf((Object)this.gatewayType) + " gateway as the outcoming transition from '" + sourceActivity.getName() + "'.");
    }

    public String getSourceActivityId() {
        return this.sourceActivityId;
    }

    public GatewayType getGatewayType() {
        return this.gatewayType;
    }

    public List<TransitionToAdd> getTransitions() {
        return this.transitions;
    }

    public static class TransitionToAdd {
        @JsonProperty(required=true)
        private String targetActivityId;
        @JsonProperty
        private Condition condition;

        public String getTargetActivityId() {
            return this.targetActivityId;
        }

        public Condition getCondition() {
            return this.condition;
        }

        @JsonProperty(required=true)
        public void setTargetActivityId(String targetActivityId) {
            this.targetActivityId = targetActivityId;
        }

        @JsonProperty
        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public TransitionToAdd(String targetActivityId, Condition condition) {
            this.targetActivityId = targetActivityId;
            this.condition = condition;
        }

        public TransitionToAdd() {
        }
    }
}

