/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import java.util.UUID;

public class SetActivityAsOutgoingTransitionFromSourceActivityIdTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "set_activity_as_outgoing_transition_from_source_activityId", "Sets a direct, unconditional transition from a source activity to a target activity.\nIf an outgoing transition already exists for the source activity (either direct or to a gateway), it will be overwritten.\nThis is used for simple, direct flows between two activities.\nReturns a confirmation of the created transition: { \"sourceActivityId\": \"<id>\", \"targetActivityId\": \"<id>\" }\n", "To create a direct transition between activities, write { \"sourceActivityId\": \"<id>\", \"targetActivityId\": \"<id>\" }", SetActivityAsOutgoingTransitionFromSourceActivityIdTool.class);
    private final String sourceActivityId;
    private final String targetActivityId;

    @JsonCreator
    public SetActivityAsOutgoingTransitionFromSourceActivityIdTool(@JsonProperty(value="sourceActivityId") String sourceActivityId, @JsonProperty(value="targetActivityId") String targetActivityId) {
        this.sourceActivityId = sourceActivityId;
        this.targetActivityId = targetActivityId;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.sourceActivityId == null || this.sourceActivityId.isBlank() || this.targetActivityId == null || this.targetActivityId.isBlank()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"sourceActivityId\" and \"targetActivityId\".");
        }
        Process process = toolContext.getProcess();
        Activity sourceActivity = process.getActivities().stream().filter(act -> act.getId().equals(this.sourceActivityId)).findFirst().orElse(null);
        if (sourceActivity == null) {
            return new ToolResult(false, "Error: Source activity with activityId: '" + this.sourceActivityId + "' doesn't exist!.");
        }
        Activity targetActivity = process.getActivities().stream().filter(act -> act.getId().equals(this.targetActivityId)).findFirst().orElse(null);
        if (targetActivity == null) {
            return new ToolResult(false, "Error: Target activity with activityId: '" + this.targetActivityId + "' doesn't exist!.");
        }
        process.getTransitions().removeIf(transition -> transition.getSourceId().equals(this.sourceActivityId));
        Transition transition2 = new Transition(UUID.randomUUID().toString(), this.sourceActivityId, this.targetActivityId);
        process.getTransitions().add(transition2);
        return new ToolResult(true, "Successfully set activity '" + targetActivity.getName() + "' as the outcoming transition from '" + sourceActivity.getName() + "'.");
    }

    public String getSourceActivityId() {
        return this.sourceActivityId;
    }

    public String getTargetActivityId() {
        return this.targetActivityId;
    }
}

