/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GetOutgoingTransitionOfActivitiesTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "get_outgoing_transition_of_activities", "Gets the details of the outgoing transitions from one or more activities. Tool returns a list of transition details (with their types and conditions of transition to each activity) in the following format: { \"results\": [ { \"activityId\": \"<id>\", \"outcomingTransition\": { ... } } ] }", "To get the outcoming transitions of activities, write { \"activityIds\": [\"<id1>\", \"<id2>\"] }", GetOutgoingTransitionOfActivitiesTool.class);
    private final List<String> activityIds;

    @JsonCreator
    public GetOutgoingTransitionOfActivitiesTool(@JsonProperty(value="activityIds") List<String> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityIds == null || this.activityIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"activityIds\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String activityId : this.activityIds) {
            Optional<Activity> activityOpt = process.getActivities().stream().filter(act -> act.getId().equals(activityId)).findFirst();
            if (activityOpt.isEmpty()) {
                errors.add((CallSite)((Object)("Error: Activity with activityId: '" + activityId + "' doesn't exist!.")));
                continue;
            }
            Activity activity = activityOpt.get();
            List<Transition> outgoingTransitions = process.getTransitions().stream().filter(transition -> transition.getSourceId().equals(activityId)).toList();
            if (outgoingTransitions.isEmpty()) {
                results.add((CallSite)((Object)("Activity '" + activity.getName() + "' (activityId: " + activityId + "): No outcoming transition defined.")));
                continue;
            }
            String transitionDetails = outgoingTransitions.stream().map(t -> "Transition to: " + t.getTargetId() + (String)(t.getCondition() != null ? ", Condition: " + t.getCondition().toConditionText() : "")).reduce("", (acc, item) -> acc.isEmpty() ? item : acc + ", " + item);
            results.add((CallSite)((Object)("Activity '" + activity.getName() + "' (activityId: " + activityId + "):\n" + transitionDetails)));
        }
        Object data = "";
        if (results.size() > 0) {
            data = (String)data + "Successfully retrieved outcoming transitions:\n" + String.join((CharSequence)"\n\n", results);
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Errors:\n" + String.join((CharSequence)"\n", errors);
        }
        if (results.isEmpty() && errors.size() > 0) {
            return new ToolResult(false, (String)data);
        }
        return new ToolResult(true, (String)(((String)data).isEmpty() ? "No activities processed." : data));
    }

    public List<String> getActivityIds() {
        return this.activityIds;
    }
}

