/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.AcceptButton;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GetAcceptButtonsOfActivitiesTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "get_accept_buttons_of_activities", "Retrieves all accept buttons associated with one or more activities. Returns a list of activities with their buttons in the following format: { \"results\": [ { \"activityId\": \"<id>\", \"acceptButtons\": [ { \"acceptButtonId\": \"<id>\", \"acceptButtonName\": \"<name>\" } ] } ] }", "To get all accept buttons for activities, write { \"activityIds\": [\"<id1>\", \"<id2>\"] }", GetAcceptButtonsOfActivitiesTool.class);
    private final List<String> activityIds;

    @JsonCreator
    public GetAcceptButtonsOfActivitiesTool(@JsonProperty(value="activityIds") List<String> activityIds) {
        this.activityIds = activityIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityIds == null || this.activityIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting a non-empty \"activityIds\" array.");
        }
        Process process = toolContext.getProcess();
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String activityId : this.activityIds) {
            Optional<Activity> activity = process.getActivities().stream().filter(act -> act.getId().equals(activityId)).findFirst();
            if (activity.isEmpty()) {
                errors.add((CallSite)((Object)("Error: Activity with activityId: '" + activityId + "' doesn't exist!.")));
                continue;
            }
            Activity act2 = activity.get();
            if (act2.getAcceptButtons().isEmpty()) {
                results.add((CallSite)((Object)("Activity '" + act2.getName() + "' (ID: " + activityId + "): No accept buttons found.")));
                continue;
            }
            Object formattedButtons = "";
            int index = 1;
            for (AcceptButton button : act2.getAcceptButtons()) {
                if (!((String)formattedButtons).isEmpty()) {
                    formattedButtons = (String)formattedButtons + "\n";
                }
                formattedButtons = (String)formattedButtons + "  " + index + ". acceptButtonId: " + button.getId() + ", acceptButtonName: " + button.getName();
                ++index;
            }
            results.add((CallSite)((Object)("Activity '" + act2.getName() + "' (activityId: " + activityId + "):\n" + (String)formattedButtons)));
        }
        Object data = "";
        if (results.size() > 0) {
            data = (String)data + "Successfully retrieved accept buttons:\n" + String.join((CharSequence)"\n\n", results);
        }
        if (errors.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n\n";
            }
            data = (String)data + "Errors:\n" + String.join((CharSequence)"\n", errors);
        }
        if (results.isEmpty() && errors.size() > 0) {
            return new ToolResult(false, (String)data);
        }
        return new ToolResult(true, (String)(((String)data).isEmpty() ? "No activities processed." : data));
    }

    public List<String> getActivityIds() {
        return this.activityIds;
    }
}

