/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.assistant.agent.transition.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.suncode.pwfl.assistant.AgentType;
import com.suncode.pwfl.assistant.tools.Tool;
import com.suncode.pwfl.assistant.tools.ToolContext;
import com.suncode.pwfl.assistant.tools.ToolDefinition;
import com.suncode.pwfl.assistant.tools.ToolResult;
import com.suncode.pwfl.workflow.process.map.AcceptButton;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import java.util.ArrayList;
import java.util.List;

public class DeleteAcceptButtonsOnActivityTool
implements Tool {
    public static final ToolDefinition DEFINITION = new ToolDefinition(AgentType.TRANSITION, "delete_accept_buttons_on_activity", "Deletes one or more accept buttons from a specified activity. Returns the IDs of the deleted buttons in the following format: { \"activityId\": \"<id>\", \"deletedAcceptButtonIds\": [\"<id1>\", \"<id2>\"] }", "To delete accept buttons, write { \"activityId\": \"<id>\", \"acceptButtonIds\": [\"<id1>\", \"<id2>\"] }", DeleteAcceptButtonsOnActivityTool.class);
    private final String activityId;
    private final List<String> acceptButtonIds;

    @JsonCreator
    public DeleteAcceptButtonsOnActivityTool(@JsonProperty(value="activityId") String activityId, @JsonProperty(value="acceptButtonIds") List<String> acceptButtonIds) {
        this.activityId = activityId;
        this.acceptButtonIds = acceptButtonIds;
    }

    @Override
    public ToolResult execute(ToolContext toolContext) {
        if (this.activityId == null || this.activityId.isBlank() || this.acceptButtonIds == null || this.acceptButtonIds.isEmpty()) {
            return new ToolResult(false, "Error: Invalid payload. Expecting \"activityId\" and a non-empty \"acceptButtonIds\" array.");
        }
        Process process = toolContext.getProcess();
        Activity activity = process.getActivities().stream().filter(act -> act.getId().equals(this.activityId)).findFirst().orElse(null);
        if (activity == null) {
            return new ToolResult(false, "Error: Activity with activityId: '" + this.activityId + "' doesn't exist!.");
        }
        ArrayList<String> deletedButtonIds = new ArrayList<String>();
        ArrayList<String> notFoundButtonIds = new ArrayList<String>();
        for (String acceptButtonId : this.acceptButtonIds) {
            int buttonIndex = -1;
            for (int i = 0; i < activity.getAcceptButtons().size(); ++i) {
                AcceptButton button = activity.getAcceptButtons().get(i);
                if (!button.getId().equals(acceptButtonId)) continue;
                buttonIndex = i;
                break;
            }
            if (buttonIndex == -1) {
                notFoundButtonIds.add(acceptButtonId);
                continue;
            }
            activity.getAcceptButtons().remove(buttonIndex);
            deletedButtonIds.add(acceptButtonId);
        }
        Object data = "";
        if (deletedButtonIds.size() > 0) {
            data = (String)data + "Successfully deleted " + deletedButtonIds.size() + " buttons from activity '" + this.activityId + "': " + String.join((CharSequence)", ", deletedButtonIds) + ".";
        }
        if (notFoundButtonIds.size() > 0) {
            if (!((String)data).isEmpty()) {
                data = (String)data + "\n";
            }
            data = (String)data + "Buttons not found on activity '" + this.activityId + "': " + String.join((CharSequence)", ", notFoundButtonIds) + ".";
        }
        if (deletedButtonIds.isEmpty() && !notFoundButtonIds.isEmpty()) {
            return new ToolResult(false, (String)data);
        }
        return new ToolResult(true, (String)(((String)data).isEmpty() ? "No buttons were deleted." : data));
    }

    public String getActivityId() {
        return this.activityId;
    }

    public List<String> getAcceptButtonIds() {
        return this.acceptButtonIds;
    }
}

